/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.config.DimensionInfo;
import org.orecruncher.dsurround.config.libraries.AssetLibraryEvent;
import org.orecruncher.dsurround.config.libraries.IDimensionInformation;
import org.orecruncher.dsurround.config.libraries.IDimensionLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.events.HandlerPriority;

public class DimensionInformation
implements IDimensionInformation {
    private final IDimensionLibrary dimensionLibrary;
    private DimensionInfo info;

    public DimensionInformation(IDimensionLibrary dimensionLibrary) {
        this.dimensionLibrary = dimensionLibrary;
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(state -> {
            this.info = null;
        });
        AssetLibraryEvent.RELOAD.register((x, y) -> {
            this.info = null;
        }, HandlerPriority.HIGH);
    }

    @Override
    public ResourceLocation name() {
        return this.getInfo().getName();
    }

    @Override
    public ClientLevel level() {
        return GameUtils.getWorld().orElseThrow();
    }

    @Override
    public int seaLevel() {
        return this.getInfo().getSeaLevel();
    }

    @Override
    public boolean alwaysOutside() {
        return this.getInfo().alwaysOutside();
    }

    @Override
    public int getSpaceHeight() {
        return this.getInfo().getSpaceHeight();
    }

    @Override
    public int getCloudHeight() {
        return this.getInfo().getCloudHeight();
    }

    @Override
    public boolean getCompassWobble() {
        return this.getInfo().getCompassWobble();
    }

    private DimensionInfo getInfo() {
        if (this.info == null) {
            this.info = this.dimensionLibrary.getData((Level)this.level());
        }
        return this.info;
    }
}

