/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.ItemClassType;
import org.orecruncher.dsurround.config.libraries.IItemLibrary;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;
import org.orecruncher.dsurround.tags.ItemEffectTags;
import org.orecruncher.dsurround.tags.ItemTags;

public class ItemLibrary
implements IItemLibrary {
    private final ITagLibrary tagLibrary;
    private final IModLog logger;
    private final Configuration config;
    private final Reference2ObjectOpenHashMap<Item, ISoundFactory> itemEquipFactories = new Reference2ObjectOpenHashMap();
    private final Reference2ObjectOpenHashMap<Item, ISoundFactory> itemSwingFactories = new Reference2ObjectOpenHashMap();
    private final Reference2ObjectOpenHashMap<Item, ISoundFactory> itemArmorStepFactories = new Reference2ObjectOpenHashMap();
    private int version;

    public ItemLibrary(ITagLibrary tagLibrary, Configuration config, IModLog logger) {
        this.tagLibrary = tagLibrary;
        this.logger = ModLog.createChild(logger, "ItemLibrary");
        this.config = config;
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        if (scope != IReloadEvent.Scope.RESOURCES) {
            ++this.version;
            this.itemEquipFactories.clear();
            this.itemSwingFactories.clear();
            this.itemArmorStepFactories.clear();
            this.logger.info("[ItemLibrary] Configured; version is now %d", this.version);
        }
    }

    @Override
    public Optional<ISoundFactory> getItemEquipSound(ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ISoundFactory)this.itemEquipFactories.computeIfAbsent((Object)stack.getItem(), k -> this.resolve(stack, ItemClassType::getToolBarSound, ItemClassType.NONE::getToolBarSound)));
    }

    @Override
    public Optional<ISoundFactory> getItemSwingSound(ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ISoundFactory)this.itemSwingFactories.computeIfAbsent((Object)stack.getItem(), k -> this.resolve(stack, ItemClassType::getSwingSound, () -> null)));
    }

    @Override
    public Optional<ISoundFactory> getEquipableStepAccentSound(ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ISoundFactory)this.itemArmorStepFactories.computeIfAbsent((Object)stack.getItem(), k -> ItemLibrary.resolveEquipableStepSound(stack)));
    }

    @Override
    public Stream<String> dump() {
        Set itemRegistry = RegistryUtils.getRegistry(Registries.ITEM).map(Registry::entrySet).orElseThrow();
        return itemRegistry.stream().map(kvp -> this.formatItemOutput(((ResourceKey)kvp.getKey()).location(), (Item)kvp.getValue())).sorted();
    }

    @Nullable
    private static ISoundFactory resolveEquipableStepSound(ItemStack stack) {
        SoundEvent sound = ItemLibrary.getEquipableSoundEvent(stack);
        if (sound != null) {
            return SoundFactoryBuilder.create(sound).category(SoundSource.PLAYERS).volume(0.07f).pitch(0.8f, 1.0f).build();
        }
        return null;
    }

    @Nullable
    private ISoundFactory resolve(ItemStack stack, Function<ItemClassType, ISoundFactory> resolveSound, Supplier<ISoundFactory> defaultSoundFactory) {
        ItemClassType itemClassType = this.resolveClassType(stack);
        if (itemClassType == ItemClassType.NONE) {
            SoundEvent itemEquipSound = this.getSoundEvent(stack);
            if (itemEquipSound != null) {
                return SoundFactoryBuilder.create(itemEquipSound).category(SoundSource.PLAYERS).volume(0.25f).pitch(0.8f, 1.2f).build();
            }
            return defaultSoundFactory.get();
        }
        return resolveSound.apply(itemClassType);
    }

    @Nullable
    private static SoundEvent getEquipableSoundEvent(ItemStack stack) {
        SoundEvent itemEquipSound = null;
        Equipable equipable = Equipable.get((ItemStack)stack);
        if (equipable != null) {
            itemEquipSound = (SoundEvent)equipable.getEquipSound().value();
        }
        return itemEquipSound;
    }

    @Nullable
    private SoundEvent getSoundEvent(ItemStack stack) {
        Item item;
        SoundEvent itemEquipSound = ItemLibrary.getEquipableSoundEvent(stack);
        if (itemEquipSound != null) {
            return itemEquipSound;
        }
        if (this.config.entityEffects.enableToolbarBlockSounds && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            SoundType soundType = blockItem.getBlock().defaultBlockState().getSoundType();
            itemEquipSound = soundType.getStepSound();
        }
        if (itemEquipSound != null) {
            return itemEquipSound;
        }
        if (this.tagLibrary.is(ItemTags.LAVA_BUCKETS, stack)) {
            itemEquipSound = SoundEvents.BUCKET_FILL_LAVA;
        } else if (this.tagLibrary.is(ItemTags.WATER_BUCKETS, stack)) {
            itemEquipSound = SoundEvents.BUCKET_FILL;
        } else if (this.tagLibrary.is(ItemTags.ENTITY_WATER_BUCKETS, stack)) {
            itemEquipSound = SoundEvents.BUCKET_FILL_FISH;
        } else if (this.tagLibrary.is(ItemTags.MILK_BUCKETS, stack)) {
            itemEquipSound = SoundEvents.BUCKET_FILL;
        }
        return itemEquipSound;
    }

    private ItemClassType resolveClassType(ItemStack stack) {
        if (this.tagLibrary.is(ItemEffectTags.AXES, stack)) {
            return ItemClassType.AXE;
        }
        if (this.tagLibrary.is(ItemEffectTags.BOOKS, stack)) {
            return ItemClassType.BOOK;
        }
        if (this.tagLibrary.is(ItemEffectTags.BOWS, stack)) {
            return ItemClassType.BOW;
        }
        if (this.tagLibrary.is(ItemEffectTags.POTIONS, stack)) {
            return ItemClassType.POTION;
        }
        if (this.tagLibrary.is(ItemEffectTags.CROSSBOWS, stack)) {
            return ItemClassType.CROSSBOW;
        }
        if (this.tagLibrary.is(ItemEffectTags.SHIELDS, stack)) {
            return ItemClassType.SHIELD;
        }
        if (this.tagLibrary.is(ItemEffectTags.SWORDS, stack)) {
            return ItemClassType.SWORD;
        }
        if (this.tagLibrary.is(ItemEffectTags.TOOLS, stack)) {
            return ItemClassType.TOOL;
        }
        return ItemClassType.NONE;
    }

    private String formatItemOutput(ResourceLocation id, Item item) {
        String tags = RegistryUtils.getRegistryEntry(Registries.ITEM, item).map(e -> {
            Stream t = this.tagLibrary.streamTags(e);
            return this.tagLibrary.asString(t);
        }).orElse("null");
        return id.toString() + "\nTags: " + tags + "\n";
    }
}

