/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.config.SoundMapping;
import org.orecruncher.dsurround.config.data.SoundMappingConfigRule;
import org.orecruncher.dsurround.config.data.SoundMetadataConfig;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.lib.CodecExtensions;
import org.orecruncher.dsurround.lib.Comparers;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.platform.IMinecraftDirectories;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundFactory;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;
import org.orecruncher.dsurround.sound.SoundMetadata;

public final class SoundLibrary
implements ISoundLibrary {
    private static final String SOUNDS_JSON = "sounds.json";
    private static final String FACTORY_JSON = "sound_factories.json";
    private static final String SOUND_CONFIG_FILE = "soundconfig.json";
    private static final String SOUND_MAPPING_JSON = "sound_mappings.json";
    private static final UnboundedMapCodec<String, SoundMetadataConfig> SOUND_FILE_CODEC = Codec.unboundedMap((Codec)Codec.STRING, SoundMetadataConfig.CODEC);
    private static final Codec<List<SoundFactory>> FACTORY_FILE_CODEC = Codec.list(SoundFactory.CODEC);
    private static final Codec<List<IndividualSoundConfigEntry>> SOUND_CONFIG_CODEC = Codec.list(IndividualSoundConfigEntry.CODEC);
    private static final Codec<List<SoundMappingConfigRule>> SOUND_MAPPING_CODEC = Codec.list(SoundMappingConfigRule.CODEC);
    private static final ResourceLocation MISSING_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"missing_sound");
    private static final SoundEvent MISSING = SoundEvent.createVariableRangeEvent((ResourceLocation)MISSING_RESOURCE);
    private static final ResourceLocation THUNDER_SOUND = SoundEvents.LIGHTNING_BOLT_THUNDER.getLocation();
    private static final Set<String> SOUND_REMAP_BLOCKED_MOBS = ImmutableSet.of((Object)"creeper");
    private static final BlockPos.MutableBlockPos MUTABLE_BLOCK_POS = new BlockPos.MutableBlockPos();
    private final IModLog logger;
    private final Configuration config;
    private final Path soundConfigPath;
    private final Object2ObjectOpenHashMap<ResourceLocation, SoundEvent> myRegistry = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<ResourceLocation, SoundMetadata> soundMetadata = new Object2ObjectOpenHashMap();
    private final Map<ResourceLocation, IndividualSoundConfigEntry> individualSoundConfiguration = new Object2ObjectOpenHashMap();
    private final Map<ResourceLocation, ISoundFactory> soundFactories = new Object2ObjectOpenHashMap();
    private final Set<ResourceLocation> blockedSounds = new ObjectOpenHashSet();
    private final Set<ResourceLocation> culledSounds = new ObjectOpenHashSet();
    private final List<ResourceLocation> startupSounds = new ArrayList<ResourceLocation>();
    private final Map<ResourceLocation, SoundMapping> soundRemappings = new Object2ObjectOpenHashMap();
    private List<IndividualSoundConfigEntry> soundConfiguration = new ArrayList<IndividualSoundConfigEntry>();

    public SoundLibrary(Configuration config, IModLog logger, IMinecraftDirectories directories) {
        this.logger = ModLog.createChild(logger, "SoundLibrary");
        this.config = config;
        this.myRegistry.defaultReturnValue((Object)MISSING);
        this.soundMetadata.defaultReturnValue((Object)new SoundMetadata());
        this.soundConfigPath = directories.getModConfigDirectory().resolve(SOUND_CONFIG_FILE);
        this.loadSoundConfiguration();
    }

    @Override
    public Stream<String> dump() {
        return this.myRegistry.values().stream().sorted((c1, c2) -> Comparers.IDENTIFIER_NATURAL_COMPARABLE.compare(c1.getLocation(), c2.getLocation())).map(Object::toString);
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        if (scope == IReloadEvent.Scope.TAGS) {
            return;
        }
        this.myRegistry.clear();
        this.soundMetadata.clear();
        this.soundFactories.clear();
        this.soundRemappings.clear();
        this.loadSoundConfiguration();
        BuiltInRegistries.SOUND_EVENT.forEach(se -> this.myRegistry.put((Object)se.getLocation(), se));
        Collection<DiscoveredResource<DiscoveredResource>> soundFiles = resourceUtilities.findResources(SOUND_FILE_CODEC, SOUNDS_JSON);
        soundFiles.forEach(this::registerSoundFile);
        Collection<DiscoveredResource<List<SoundFactory>>> findResults = resourceUtilities.findModResources(FACTORY_FILE_CODEC, FACTORY_JSON);
        findResults.forEach(this::registerSoundFactories);
        Collection<DiscoveredResource<List<SoundMappingConfigRule>>> soundMappings = resourceUtilities.findModResources(SOUND_MAPPING_CODEC, SOUND_MAPPING_JSON);
        soundMappings.forEach(this::registerSoundRemappings);
        this.logger.info("Number of SoundEvents cached: %d", this.myRegistry.size());
        this.logger.info("Number of factories cached: %d", this.soundFactories.size());
        this.logger.info("Number of sound remappings cached: %d", this.soundRemappings.size());
    }

    @Override
    public SoundEvent getSound(String sound) {
        return this.getSound(ResourceLocation.parse((String)sound));
    }

    @Override
    public SoundEvent getSound(ResourceLocation sound) {
        Objects.requireNonNull(sound);
        SoundEvent se = (SoundEvent)this.myRegistry.get((Object)sound);
        if (se == MISSING) {
            this.logger.warn("Unable to locate sound '%s'", sound.toString());
        }
        return se;
    }

    @Override
    public Collection<SoundEvent> getRegisteredSoundEvents() {
        return this.myRegistry.values();
    }

    @Override
    public SoundMetadata getSoundMetadata(ResourceLocation sound) {
        SoundMetadata result = (SoundMetadata)this.soundMetadata.get((Object)Objects.requireNonNull(sound));
        return result.isDefault() ? new SoundMetadata(sound) : result;
    }

    @Override
    public Optional<ISoundFactory> getSoundFactory(ResourceLocation factoryLocation) {
        return Optional.ofNullable(this.soundFactories.get(factoryLocation));
    }

    @Override
    public ISoundFactory getSoundFactoryOrDefault(ResourceLocation factoryLocation) {
        return this.soundFactories.computeIfAbsent(factoryLocation, loc -> SoundFactoryBuilder.create(loc).build());
    }

    @Override
    public ISoundFactory getSoundFactoryForMusic(Music music) {
        return this.soundFactories.computeIfAbsent(((SoundEvent)music.getEvent().value()).getLocation(), loc -> SoundFactoryBuilder.create(music).build());
    }

    @Override
    public boolean isBlocked(ResourceLocation sound) {
        return this.blockedSounds.contains(Objects.requireNonNull(sound));
    }

    @Override
    public boolean isCulled(ResourceLocation sound) {
        return this.culledSounds.contains(Objects.requireNonNull(sound));
    }

    @Override
    public float getVolumeScale(SoundSource category, ResourceLocation sound) {
        float scale = 1.0f;
        IndividualSoundConfigEntry entry = this.individualSoundConfiguration.get(Objects.requireNonNull(sound));
        if (entry != null && entry.isNotDefault()) {
            scale = (float)entry.volumeScale / 100.0f;
        }
        if (category == SoundSource.AMBIENT && sound.getNamespace().equals("dsurround")) {
            scale *= (float)this.config.soundOptions.ambientVolumeScaling / 100.0f;
        }
        return scale;
    }

    @Override
    public Optional<SoundEvent> getRandomStartupSound() {
        if (this.startupSounds.isEmpty()) {
            return Optional.empty();
        }
        int idx = 0;
        if (this.startupSounds.size() > 1) {
            idx = Randomizer.current().nextInt(this.startupSounds.size());
        }
        return Optional.of(SoundEvent.createVariableRangeEvent((ResourceLocation)this.startupSounds.get(idx)));
    }

    @Override
    public Collection<IndividualSoundConfigEntry> getIndividualSoundConfigs() {
        return this.soundConfiguration;
    }

    @Override
    public void saveIndividualSoundConfigs(Collection<IndividualSoundConfigEntry> configs) {
        this.blockedSounds.clear();
        this.soundConfiguration = configs.stream().filter(IndividualSoundConfigEntry::isNotDefault).collect(Collectors.toList());
        this.postProcess();
        this.save();
    }

    @Override
    public Optional<SoundInstance> remapSound(SoundInstance soundInstance) {
        if (soundInstance instanceof ConfigSoundInstance) {
            return Optional.empty();
        }
        ResourceLocation soundLocation = soundInstance.getLocation();
        if (THUNDER_SOUND.equals((Object)soundLocation) ? !this.config.soundOptions.replaceThunderSounds : !this.config.soundOptions.remapSounds) {
            return Optional.empty();
        }
        SoundMapping mappingRule = this.soundRemappings.get(soundLocation);
        if (mappingRule != null) {
            Optional<ISoundFactory> soundFactory;
            BlockPos pos;
            ClientLevel level;
            BlockState blockState = null;
            if (mappingRule.isBlockStateNeeded() && ((blockState = (level = GameUtils.getWorld().orElseThrow()).getBlockState(pos = BlockPos.containing((double)soundInstance.getX(), (double)(soundInstance.getY() + 0.25), (double)soundInstance.getZ()).below())).isAir() || !blockState.isSolid())) {
                Direction dir;
                Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
                while (iterator.hasNext() && ((blockState = level.getBlockState((BlockPos)MUTABLE_BLOCK_POS.setWithOffset((Vec3i)pos, dir = (Direction)iterator.next()))).isAir() || !blockState.isSolid())) {
                }
            }
            if ((soundFactory = mappingRule.findMatch(blockState).map(this::getSoundFactoryOrDefault)).isPresent()) {
                soundInstance.resolve(GameUtils.getSoundManager());
                float volumeScale = soundInstance.getVolume();
                return Optional.of(soundFactory.get().createAtLocation(soundInstance.getX(), soundInstance.getY(), soundInstance.getZ(), volumeScale));
            }
        }
        return Optional.empty();
    }

    @Nullable
    private ResourceLocation remapMobStepSound(SoundInstance soundInstance) {
        String mobType;
        ResourceLocation soundLocation = soundInstance.getLocation();
        String path = soundLocation.getPath();
        if (path.startsWith("entity.") && path.endsWith("step") && !SOUND_REMAP_BLOCKED_MOBS.contains(mobType = path.substring(7, path.indexOf(46, 7)))) {
            ClientLevel level = GameUtils.getWorld().orElseThrow();
            BlockPos pos = BlockPos.containing((double)soundInstance.getX(), (double)soundInstance.getY(), (double)soundInstance.getZ()).below();
            soundLocation = level.getBlockState(pos).getSoundType().getStepSound().getLocation();
            this.logger.debug("Mob sound remapping from %s to %s", soundInstance.getLocation(), soundLocation);
            return soundLocation;
        }
        return null;
    }

    private void registerSoundFile(DiscoveredResource<Map<String, SoundMetadataConfig>> soundFile) {
        Map<String, SoundMetadataConfig> result = soundFile.resourceContent();
        result.forEach((key, value) -> {
            ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)soundFile.namespace(), (String)key);
            if (!this.myRegistry.containsKey((Object)loc)) {
                this.myRegistry.put((Object)loc, (Object)SoundEvent.createVariableRangeEvent((ResourceLocation)loc));
            }
            if (!value.isDefault()) {
                SoundMetadata data = new SoundMetadata(loc, (SoundMetadataConfig)value);
                this.soundMetadata.put((Object)loc, (Object)data);
            }
        });
        this.logger.debug("Registered %d sounds for namespace %s", soundFile.resourceContent().size(), soundFile.namespace());
    }

    private void registerSoundRemappings(DiscoveredResource<List<SoundMappingConfigRule>> mappings) {
        for (SoundMappingConfigRule mapping : mappings.resourceContent()) {
            if (!this.soundRemappings.containsKey(mapping.soundEvent())) {
                this.soundRemappings.put(mapping.soundEvent(), SoundMapping.of(mapping));
                continue;
            }
            SoundMapping existingMapping = this.soundRemappings.get(mapping.soundEvent());
            existingMapping.merge(mapping);
        }
        this.logger.debug("Registered %d sound remappings for namespace %s", mappings.resourceContent().size(), mappings.namespace());
    }

    private void registerSoundFactories(DiscoveredResource<List<SoundFactory>> factories) {
        factories.resourceContent().forEach(factory -> this.soundFactories.put(factory.getLocation(), (ISoundFactory)factory));
        this.logger.debug("Registered %d sound factories for namespace %s", factories.resourceContent().size(), factories.namespace());
    }

    private void loadSoundConfiguration() {
        this.soundConfiguration.clear();
        this.blockedSounds.clear();
        try {
            if (Files.exists(this.soundConfigPath, new LinkOption[0])) {
                String content = Files.readString(this.soundConfigPath);
                Optional<List<IndividualSoundConfigEntry>> result = CodecExtensions.deserialize(content, SOUND_CONFIG_CODEC);
                result.ifPresentOrElse(cfgList -> this.soundConfiguration.addAll((Collection<IndividualSoundConfigEntry>)cfgList), () -> this.logger.warn("Unable to obtain content of %s!", SOUND_CONFIG_FILE));
            } else {
                this.addSoundConfigDefaults();
            }
        }
        catch (Throwable t) {
            this.logger.error(t, "Unable to load sound configuration %s! Resetting to defaults.", SOUND_CONFIG_FILE);
            this.addSoundConfigDefaults();
        }
        this.postProcess();
        this.save();
    }

    private void addSoundConfigDefaults() {
        this.addSoundConfig("minecraft:entity.sheep.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.chicken.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.cow.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.pig.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.llama.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.wither.spawn", 10, false, true, false);
        this.addSoundConfig("minecraft:entity.wither.death", 10, false, true, false);
        this.addSoundConfig("minecraft:entity.ender_dragon.death", 10, false, true, false);
        this.addSoundConfig("minecraft:entity.experience_orb.pickup", 100, false, false, true);
        this.addSoundConfig("minecraft:entity.chicken.egg", 100, false, false, true);
        this.addSoundConfig("minecraft:ambient.underwater.exit", 100, false, false, true);
        this.addSoundConfig("minecraft:block.water.ambient", 100, true, false, false);
    }

    private void addSoundConfig(String id, int volumeScale, boolean block, boolean cull, boolean startup) {
        IndividualSoundConfigEntry entry = new IndividualSoundConfigEntry(ResourceLocation.parse((String)id), volumeScale, block, cull, startup);
        this.soundConfiguration.add(entry);
    }

    private void postProcess() {
        this.soundConfiguration.removeIf(e -> !e.isNotDefault());
        this.soundConfiguration.sort((e1, e2) -> Comparers.IDENTIFIER_NATURAL_COMPARABLE.compare(e1.soundEventId, e2.soundEventId));
        this.soundConfiguration.forEach(e -> {
            this.individualSoundConfiguration.put(e.soundEventId, (IndividualSoundConfigEntry)e);
            if (e.startup) {
                this.startupSounds.add(e.soundEventId);
            }
            if (e.block || e.volumeScale == 0) {
                this.blockedSounds.add(e.soundEventId);
            }
            if (e.cull) {
                this.culledSounds.add(e.soundEventId);
            }
        });
    }

    private void save() {
        try {
            Optional<String> result = CodecExtensions.serialize(SOUND_CONFIG_CODEC, this.soundConfiguration);
            if (result.isPresent()) {
                Files.writeString(this.soundConfigPath, (CharSequence)result.get(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (Throwable t) {
            this.logger.error(t, "Unable to save sound configuration %s!", SOUND_CONFIG_FILE);
        }
    }
}

