/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.orecruncher.dsurround.Constants;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.ClientTagLoader;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.lib.system.IStopwatch;
import org.orecruncher.dsurround.lib.system.ISystemClock;
import org.orecruncher.dsurround.tags.ModTags;

public class TagLibrary
implements ITagLibrary {
    private final IModLog logger;
    private final ISystemClock systemClock;
    private final Map<TagKey<?>, Collection<ResourceLocation>> tagCache;
    private final ClientTagLoader tagLoader;
    private boolean isConnected;

    public TagLibrary(IModLog logger, ISystemClock systemClock) {
        this.logger = ModLog.createChild(logger, "TagLibrary");
        this.systemClock = systemClock;
        this.tagCache = new Reference2ObjectOpenHashMap();
        this.tagLoader = new ClientTagLoader(ResourceUtilities.createForCurrentState(), logger, this.systemClock);
        ClientState.ON_CONNECT.register(this::onConnect);
        ClientState.ON_DISCONNECT.register(this::onDisconnect);
    }

    @Override
    public boolean is(TagKey<Block> tagKey, BlockState entry) {
        if (Constants.BLOCKS_TO_IGNORE.contains(entry.getBlock())) {
            return false;
        }
        if (entry.is(tagKey)) {
            return true;
        }
        ResourceLocation location = ((ResourceKey)entry.getBlockHolder().unwrapKey().orElseThrow()).location();
        return this.isInCache(tagKey, location);
    }

    @Override
    public boolean is(TagKey<Item> tagKey, ItemStack entry) {
        if (entry.isEmpty()) {
            return false;
        }
        if (entry.is(tagKey)) {
            return true;
        }
        ResourceLocation location = ((ResourceKey)entry.getItemHolder().unwrapKey().orElseThrow()).location();
        return this.isInCache(tagKey, location);
    }

    @Override
    public boolean is(TagKey<Biome> tagKey, Biome entry) {
        Optional<Holder.Reference<Biome>> registryEntry = RegistryUtils.getRegistryEntry(Registries.BIOME, entry);
        if (registryEntry.isPresent()) {
            Holder.Reference<Biome> e = registryEntry.get();
            if (e.is(tagKey)) {
                return true;
            }
            ResourceLocation location = e.key().location();
            return this.isInCache(tagKey, location);
        }
        return false;
    }

    @Override
    public boolean is(TagKey<EntityType<?>> tagKey, EntityType<?> entry) {
        if (entry.is(tagKey)) {
            return true;
        }
        Optional<Holder.Reference<EntityType<?>>> registryEntry = RegistryUtils.getRegistryEntry(Registries.ENTITY_TYPE, entry);
        if (registryEntry.isPresent()) {
            ResourceLocation location = registryEntry.get().key().location();
            return this.isInCache(tagKey, location);
        }
        return false;
    }

    @Override
    public boolean is(TagKey<Fluid> tagKey, FluidState entry) {
        if (entry.isEmpty()) {
            return false;
        }
        if (entry.is(tagKey)) {
            return true;
        }
        Optional<Holder.Reference<Fluid>> registryEntry = RegistryUtils.getRegistryEntry(Registries.FLUID, entry.getType());
        if (registryEntry.isPresent()) {
            ResourceLocation location = registryEntry.get().key().location();
            return this.isInCache(tagKey, location);
        }
        return false;
    }

    @Override
    public Stream<String> dump() {
        return this.tagCache.entrySet().stream().map(kvp -> {
            StringBuilder builder = new StringBuilder();
            builder.append("Tag: ").append(((TagKey)kvp.getKey()).toString());
            Collection td = (Collection)kvp.getValue();
            if (td.isEmpty()) {
                builder.append("\n*** EMPTY ***");
            } else {
                this.formatHelper(builder, "Members", this.tagLoader.getCompleteIds((TagKey)kvp.getKey()));
            }
            builder.append("\n");
            return builder.toString();
        }).sorted();
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        this.tagLoader.setResourceUtilities(resourceUtilities);
        this.logger.info("[TagLibrary] Cache has %d elements", this.tagCache.size());
        if (this.isConnected) {
            this.initializeTagCache();
        }
    }

    @Override
    public <T> String asString(Stream<TagKey<T>> tagStream) {
        return tagStream.map(key -> key.location().toString()).sorted().collect(Collectors.joining(", "));
    }

    @Override
    public <T> Stream<Pair<TagKey<T>, Set<T>>> getEntriesByTag(ResourceKey<? extends Registry<T>> registryKey) {
        Registry registry = RegistryUtils.getRegistry(registryKey).orElseThrow();
        return registry.holders().flatMap(e -> this.streamTags((Holder)e).map(tag -> Pair.of((Object)tag, (Object)e.value()))).collect(Collectors.groupingBy(Pair::key, Collectors.mapping(Pair::value, Collectors.toSet()))).entrySet().stream().map(e -> Pair.of((Object)((TagKey)e.getKey()), (Object)((Set)e.getValue())));
    }

    @Override
    public <T> Stream<TagKey<T>> streamTags(Holder<T> registryEntry) {
        ResourceLocation location = ((ResourceKey)registryEntry.unwrapKey().orElseThrow()).location();
        Set tags = registryEntry.tags().collect(Collectors.toSet());
        for (Map.Entry<TagKey<?>, Collection<ResourceLocation>> kvp : this.tagCache.entrySet()) {
            if (!kvp.getValue().contains(location)) continue;
            tags.add(kvp.getKey());
        }
        return tags.stream();
    }

    private void onConnect(Minecraft client) {
        this.isConnected = true;
        this.tagLoader.setServerType(GameUtils.getServerType());
        this.initializeTagCache();
    }

    private void onDisconnect(Minecraft client) {
        this.isConnected = false;
    }

    private void initializeTagCache() {
        IStopwatch stopwatch = this.systemClock.getStopwatch();
        this.logger.info("Repopulating tag cache", new Object[0]);
        this.tagCache.clear();
        this.tagLoader.clear();
        for (TagKey<?> tagKey : ModTags.getModTags()) {
            this.tagCache.computeIfAbsent(tagKey, this.tagLoader::getMembers);
        }
        this.logger.info("Tag cache initialization complete; %d tags cached, %dmillis", this.tagCache.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private boolean isInCache(TagKey<?> tagKey, ResourceLocation entry) {
        if (!ModTags.getModTags().contains(tagKey)) {
            return false;
        }
        return this.tagCache.computeIfAbsent(tagKey, this.tagLoader::getMembers).contains(entry);
    }

    private void formatHelper(StringBuilder builder, String entryName, Collection<ResourceLocation> data) {
        builder.append("\n").append(entryName).append(" ");
        if (data.isEmpty()) {
            builder.append("NONE");
        } else {
            builder.append("[");
            for (ResourceLocation e : data) {
                builder.append("\n  ").append(e.toString());
            }
            builder.append("\n]");
        }
    }
}

