/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.tags.BlockEffectTags;

public class BlockEffectUtils {
    private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
    public static final int MAX_STRENGTH = 10;
    public static final Predicate<BlockState> HAS_FLUID = state -> !state.getFluidState().isEmpty();
    public static final Predicate<BlockState> IS_LAVA = state -> state.getFluidState().is(FluidTags.LAVA);
    public static final Predicate<BlockState> IS_WATER = state -> state.getFluidState().is(FluidTags.WATER);
    public static final Predicate<BlockState> IS_LIT_FURNACE = state -> state.getBlock() instanceof AbstractFurnaceBlock && (Boolean)state.getValue((Property)AbstractFurnaceBlock.LIT) != false;
    public static final Predicate<BlockState> IS_LIT_CAMPFIRE = CampfireBlock::isLitCampfire;
    public static final Predicate<BlockState> IS_HEAT_PRODUCER = state -> TAG_LIBRARY.is(BlockEffectTags.HEAT_PRODUCERS, (BlockState)state);
    public static final Predicate<BlockState> IS_HOT_SOURCE = state -> IS_HEAT_PRODUCER.test((BlockState)state) || IS_LIT_FURNACE.test((BlockState)state) || IS_LIT_CAMPFIRE.test((BlockState)state);

    private BlockEffectUtils() {
    }

    public static boolean blockExistsAround(Level provider, BlockPos pos, Predicate<BlockState> predicate) {
        return BlockPos.findClosestMatch((BlockPos)pos, (int)1, (int)1, blockPos -> predicate.test(provider.getBlockState(blockPos))).isPresent();
    }

    public static int countVerticalBlocks(Level provider, BlockPos pos, Predicate<BlockState> predicate, int step) {
        int count;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (count = 0; count < 10 && predicate.test(provider.getBlockState((BlockPos)mutable)); ++count) {
            mutable.setY(mutable.getY() + step);
        }
        return Mth.clamp((int)count, (int)0, (int)10);
    }
}

