/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.WaterRippleStyle;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.effects.particles.ParticleRenderCollection;
import org.orecruncher.dsurround.effects.particles.WaterRippleParticle;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.tags.FluidTags;

public class WaterRippleHandler {
    private static final Configuration.BlockEffects CONFIG = ContainerManager.resolve(Configuration.BlockEffects.class);
    private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
    private static final ParticleRenderCollection.Helper<WaterRippleParticle> rippleHelper = new ParticleRenderCollection.Helper("WaterRipples", () -> WaterRippleHandler.CONFIG.waterRippleStyle.getTexture());
    private static final double LIQUID_HEIGHT_ADJUST = 0.2111111111111111;

    private static boolean doRipples() {
        return WaterRippleHandler.CONFIG.waterRippleStyle != WaterRippleStyle.NONE;
    }

    private static void addWaterRipple(ClientLevel world, double x, double y, double z) {
        WaterRippleParticle ripple = new WaterRippleParticle(WaterRippleHandler.CONFIG.waterRippleStyle, world, x, y, z);
        rippleHelper.add(ripple);
    }

    public static void createRippleParticle(ClientLevel world, Particle particle, Vec3 position) {
        if (WaterRippleHandler.doRipples()) {
            BlockPos pos = BlockPos.containing((Position)position);
            FluidState fluidState = world.getFluidState(BlockPos.containing((Position)position));
            if (fluidState.isSource() && TAG_LIBRARY.is(FluidTags.WATER_RIPPLES, fluidState)) {
                float actualHeight = fluidState.getHeight((BlockGetter)world, pos) + (float)pos.getY();
                WaterRippleHandler.addWaterRipple(world, position.x, (double)actualHeight + 0.2111111111111111, position.z);
                if (particle != null) {
                    particle.setPos(0.0, 0.0, 0.0);
                    particle.remove();
                }
            }
        }
    }
}

