/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks;

import java.util.Optional;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.mixins.core.MixinParticleManager;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public abstract class AbstractBlockEffect
implements IBlockEffect {
    protected static final IRandomizer RANDOM = Randomizer.current();
    protected static final ISoundLibrary SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);
    protected static final IAudioPlayer AUDIO_PLAYER = ContainerManager.resolve(IAudioPlayer.class);
    protected final Level world;
    protected final double posX;
    protected final double posY;
    protected final double posZ;
    protected final BlockPos position;
    private boolean removed = false;

    protected AbstractBlockEffect(Level worldIn, double posXIn, double posYIn, double posZIn) {
        this.world = worldIn;
        this.posX = posXIn;
        this.posY = posYIn;
        this.posZ = posZIn;
        this.position = BlockPos.containing((double)posXIn, (double)posYIn, (double)posZIn);
    }

    @Override
    public BlockPos getPos() {
        return this.position;
    }

    public void addParticle(Particle particle) {
        GameUtils.getParticleManager().add(particle);
    }

    public <T extends ParticleOptions> Optional<Particle> createParticle(T parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        ParticleEngine pm = GameUtils.getParticleManager();
        MixinParticleManager t = (MixinParticleManager)pm;
        return Optional.ofNullable(t.dsurround_createParticle(parameters, x, y, z, velocityX, velocityY, velocityZ));
    }

    @Override
    public boolean isDone() {
        return this.removed;
    }

    @Override
    public void remove() {
        this.removed = true;
        this.cleanUp();
    }

    public abstract boolean shouldRemove();

    protected void cleanUp() {
    }

    @Override
    public final void tick() {
        if (this.shouldRemove()) {
            this.remove();
            return;
        }
        this.think();
        if (!this.isDone()) {
            this.soundUpdate();
        }
    }

    protected void soundUpdate() {
    }

    public abstract void think();
}

