/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks;

import java.util.Optional;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.effects.blocks.AbstractParticleEmitterEffect;

public class FlameJetEffect
extends AbstractParticleEmitterEffect {
    private static final ResourceLocation FIRE_AMBIENT = ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"fire_ambient");
    protected final boolean isLava;
    protected final SimpleParticleType particleType;
    protected final boolean isNonLiquidBlock;
    protected boolean soundFired;

    public FlameJetEffect(int strength, Level world, double x, double y, double z, boolean isNonLiquidBlock) {
        super(strength, world, x, y, z);
        this.isLava = !isNonLiquidBlock && RANDOM.nextInt(3) == 0;
        this.particleType = this.isLava ? ParticleTypes.LAVA : ParticleTypes.FLAME;
        this.isNonLiquidBlock = isNonLiquidBlock;
    }

    @Override
    protected void soundUpdate() {
        if (!this.soundFired) {
            this.soundFired = true;
            if (this.strength > 1) {
                SOUND_LIBRARY.getSoundFactory(FIRE_AMBIENT).ifPresent(f -> {
                    SimpleSoundInstance soundInstance = f.createAtLocation(this.getPos());
                    AUDIO_PLAYER.play((SoundInstance)soundInstance);
                });
            }
        }
    }

    @Override
    protected Optional<Particle> produceParticle() {
        double speedY = this.isLava ? 0.0 : (double)this.strength / 10.0;
        float scale = this.strength;
        double x = this.posX;
        double z = this.posZ;
        if (this.isNonLiquidBlock) {
            x += (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
            z += (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
            if (this.strength == 1) {
                speedY *= 0.5;
                scale *= 0.5f;
            }
        }
        Optional<Particle> particle = this.createParticle(this.particleType, x, this.posY, z, 0.0, speedY, 0.0);
        float finalScale = scale;
        particle.ifPresent(p -> {
            if (p instanceof FlameParticle) {
                p.scale(finalScale);
            }
        });
        return particle;
    }
}

