/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.runtime.IConditionEvaluator;

public abstract class BlockEffectProducer
implements IBlockEffectProducer {
    protected final IConditionEvaluator conditionEvaluator;
    protected final Script chance;
    protected final Script conditions;
    public static final int MAX_STRENGTH = 10;

    protected BlockEffectProducer(Script chance, Script conditions) {
        this.chance = chance;
        this.conditions = conditions;
        this.conditionEvaluator = ContainerManager.resolve(IConditionEvaluator.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canTrigger(Level world, BlockState state, BlockPos pos, IRandomizer rand) {
        if (!this.conditionEvaluator.check(this.conditions)) return false;
        Object chance = this.conditionEvaluator.eval(this.chance);
        if (!(chance instanceof Double)) return false;
        Double c = (Double)chance;
        if (!(rand.nextDouble() < c)) return false;
        return true;
    }

    @Override
    public Optional<IBlockEffect> produce(Level world, BlockState state, BlockPos pos, IRandomizer rand) {
        if (this.canTrigger(world, state, pos, rand)) {
            return this.produceImpl(world, state, pos, rand);
        }
        return Optional.empty();
    }

    protected abstract Optional<IBlockEffect> produceImpl(Level var1, BlockState var2, BlockPos var3, IRandomizer var4);

    public static int countVerticalBlocks(Level provider, BlockPos pos, Predicate<BlockState> predicate, int step) {
        int count;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (count = 0; count < 10 && predicate.test(provider.getBlockState((BlockPos)mutable)); ++count) {
            mutable.setY(mutable.getY() + step);
        }
        return Mth.clamp((int)count, (int)0, (int)10);
    }

    public static int countCubeBlocks(Level provider, BlockPos pos, Predicate<BlockState> predicate, boolean fastFirst) {
        int blockCount = 0;
        for (int k = -1; k <= 1; ++k) {
            for (int j = -1; j <= 1; ++j) {
                for (int i = -1; i <= 1; ++i) {
                    BlockState state = provider.getBlockState(pos.offset(i, j, k));
                    if (!predicate.test(state)) continue;
                    if (fastFirst) {
                        return 1;
                    }
                    ++blockCount;
                }
            }
        }
        return blockCount;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{chance: " + String.valueOf(this.chance) + "; conditions: " + String.valueOf(this.conditions) + "}";
    }
}

