/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.blocks.producers.BlockEffectProducer;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scripting.Script;

public class BlockParticleEffectProducer
extends BlockEffectProducer {
    private final IParticleSupplier supplier;

    public BlockParticleEffectProducer(Script chance, Script conditions, IParticleSupplier particleSupplier) {
        super(chance, conditions);
        this.supplier = particleSupplier;
    }

    @Override
    protected final Optional<IBlockEffect> produceImpl(Level world, BlockState state, BlockPos pos, IRandomizer rand) {
        Particle particle = this.supplier.create(world, state, pos, rand);
        this.addParticle(particle);
        return Optional.empty();
    }

    protected void addParticle(Particle particle) {
        GameUtils.getParticleManager().add(particle);
    }

    @FunctionalInterface
    public static interface IParticleSupplier {
        public Particle create(Level var1, BlockState var2, BlockPos var3, IRandomizer var4);
    }
}

