/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.orecruncher.dsurround.effects.BlockEffectUtils;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.blocks.FlameJetEffect;
import org.orecruncher.dsurround.effects.blocks.producers.BlockEffectProducer;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scripting.Script;

public class FlameJetProducer
extends BlockEffectProducer {
    public FlameJetProducer(Script chance, Script conditions) {
        super(chance, conditions);
    }

    @Override
    protected boolean canTrigger(Level world, BlockState state, BlockPos pos, IRandomizer random) {
        return world.getBlockState(pos.above()).isAir() && super.canTrigger(world, state, pos, random);
    }

    @Override
    public Optional<IBlockEffect> produceImpl(Level world, BlockState state, BlockPos pos, IRandomizer random) {
        boolean isNonLiquidBlock;
        float spawnHeight;
        int blockCount;
        if (!state.getFluidState().isEmpty()) {
            blockCount = FlameJetProducer.countVerticalBlocks(world, pos, BlockEffectUtils.IS_LAVA, -1);
            spawnHeight = (float)pos.getY() + state.getFluidState().getOwnHeight() + 0.1f;
            isNonLiquidBlock = false;
        } else {
            VoxelShape shape = state.getShape((BlockGetter)world, pos);
            if (shape.isEmpty()) {
                return Optional.empty();
            }
            double blockHeight = shape.bounds().maxY;
            spawnHeight = (float)((double)pos.getY() + blockHeight);
            isNonLiquidBlock = true;
            blockCount = state.isFaceSturdy((BlockGetter)world, pos, Direction.UP, SupportType.FULL) ? 2 : 1;
        }
        if (blockCount > 0) {
            FlameJetEffect effect = new FlameJetEffect(blockCount, world, (double)pos.getX() + 0.5, (double)spawnHeight, (double)pos.getZ() + 0.5, isNonLiquidBlock);
            return Optional.of(effect);
        }
        return Optional.empty();
    }
}

