/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.effects.BlockEffectUtils;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.blocks.BubbleJetEffect;
import org.orecruncher.dsurround.effects.blocks.producers.BlockEffectProducer;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scripting.Script;

public class UnderwaterBubbleProducer
extends BlockEffectProducer {
    public UnderwaterBubbleProducer(Script chance, Script conditions) {
        super(chance, conditions);
    }

    @Override
    protected boolean canTrigger(Level world, BlockState state, BlockPos pos, IRandomizer random) {
        if (BlockEffectUtils.IS_WATER.test(state)) {
            BlockPos belowPos = pos.below();
            BlockState belowBlock = world.getBlockState(belowPos);
            boolean isSolidBlock = belowBlock.isFaceSturdy((BlockGetter)world, belowPos, Direction.UP, SupportType.FULL);
            return isSolidBlock && super.canTrigger(world, state, pos, random);
        }
        return false;
    }

    @Override
    protected Optional<IBlockEffect> produceImpl(Level world, BlockState state, BlockPos pos, IRandomizer random) {
        int liquidBlocks = UnderwaterBubbleProducer.countVerticalBlocks(world, pos, BlockEffectUtils.IS_WATER, 1);
        if (liquidBlocks > 0) {
            BubbleJetEffect effect = new BubbleJetEffect(liquidBlocks, world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
            return Optional.of(effect);
        }
        return Optional.empty();
    }
}

