/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.orecruncher.dsurround.effects.entity.EntityEffectBase;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.tags.ItemEffectTags;

public class BowUseEffect
extends EntityEffectBase {
    private static final ResourceLocation BOW_PULL_FACTORY = ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"bow_pull");
    protected ItemStack lastActiveStack = ItemStack.EMPTY;

    @Override
    public void tick(EntityEffectInfo info) {
        if (info.isRemoved()) {
            this.lastActiveStack = ItemStack.EMPTY;
            return;
        }
        LivingEntity entity = info.getEntity();
        ItemStack currentStack = entity.getUseItem();
        if (BowUseEffect.isApplicable(currentStack)) {
            if (!ItemStack.matches((ItemStack)currentStack, (ItemStack)this.lastActiveStack)) {
                SOUND_LIBRARY.getSoundFactory(BOW_PULL_FACTORY).ifPresent(f -> {
                    EntityBoundSoundInstance sound = f.attachToEntity((Entity)entity);
                    this.playSound((SoundInstance)sound);
                });
                this.lastActiveStack = currentStack;
            }
        } else {
            this.lastActiveStack = ItemStack.EMPTY;
        }
    }

    private static boolean isApplicable(ItemStack stack) {
        return TAG_LIBRARY.is(ItemEffectTags.BOWS, stack);
    }
}

