/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import net.minecraft.client.Options;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.effects.entity.EntityEffectBase;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.effects.particles.FrostBreathParticle;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.random.MurmurHash3;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.lib.system.ITickCount;

public class BreathEffect
extends EntityEffectBase {
    private static final ISeasonalInformation SEASONAL_INFORMATION = ContainerManager.resolve(ISeasonalInformation.class);
    private final ITickCount tickCount;
    private int seed;

    public BreathEffect(ITickCount tickCount) {
        this.tickCount = tickCount;
    }

    @Override
    public void activate(EntityEffectInfo info) {
        this.seed = info.isRemoved() ? 0 : MurmurHash3.hash(info.getEntity().getId()) & 0xFFFF;
    }

    @Override
    public void tick(EntityEffectInfo info) {
        if (info.isRemoved()) {
            return;
        }
        LivingEntity entity = info.getEntity();
        if (!this.isBreathVisible(entity)) {
            return;
        }
        int c = (int)(this.tickCount.getTickCount() + (long)this.seed);
        BlockPos headPos = this.getHeadPosition(entity);
        BlockState state = entity.level().getBlockState(headPos);
        if (this.showWaterBubbles(state)) {
            int air = entity.getAirSupply();
            if (air > 0) {
                int interval = c % 3;
                if (interval == 0) {
                    this.createBubbleParticle(false);
                }
            } else if (air == 0) {
                for (int i = 0; i < 8; ++i) {
                    this.createBubbleParticle(true);
                }
            }
        } else {
            int interval = c / 10 % 8;
            if (interval < 3 && this.showFrostBreath(entity, state, headPos)) {
                this.createFrostParticle(entity);
            }
        }
    }

    protected boolean isBreathVisible(LivingEntity entity) {
        Player player = GameUtils.getPlayer().orElseThrow();
        Options settings = GameUtils.getGameSettings();
        if (entity.getId() == player.getId()) {
            return !player.isSpectator() && !settings.hideGui;
        }
        return !entity.isInvisibleTo(player) && player.hasLineOfSight((Entity)entity);
    }

    protected BlockPos getHeadPosition(LivingEntity entity) {
        return BlockPos.containing((Position)entity.getEyePosition());
    }

    protected boolean showWaterBubbles(BlockState headBlock) {
        return !headBlock.getFluidState().isEmpty();
    }

    protected boolean showFrostBreath(LivingEntity entity, BlockState headBlock, BlockPos pos) {
        if (headBlock.isAir()) {
            return SEASONAL_INFORMATION.isColdTemperature(pos);
        }
        return false;
    }

    protected void createBubbleParticle(boolean isDrowning) {
    }

    protected void createFrostParticle(LivingEntity entity) {
        FrostBreathParticle particle = new FrostBreathParticle(entity);
        this.addParticle((Particle)particle);
    }
}

