/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.effects.IEntityEffect;
import org.orecruncher.dsurround.lib.GameUtils;

public class EntityEffectInfo {
    private final WeakReference<LivingEntity> entity;
    private final Collection<IEntityEffect> effects;
    private final int version;

    private EntityEffectInfo(int version) {
        this(version, null, (Collection<IEntityEffect>)ImmutableList.of());
    }

    public EntityEffectInfo(int version, LivingEntity entity, Collection<IEntityEffect> effects) {
        this.version = version;
        this.entity = new WeakReference<LivingEntity>(entity);
        this.effects = effects;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDefault() {
        return false;
    }

    @NotNull
    public LivingEntity getEntity() {
        return Objects.requireNonNull((LivingEntity)this.entity.get());
    }

    public void activate() {
        if (this.isRemoved()) {
            return;
        }
        for (IEntityEffect e : this.effects) {
            e.activate(this);
        }
    }

    public void deactivate() {
        for (IEntityEffect e : this.effects) {
            e.deactivate(this);
        }
    }

    public void tick() {
        if (this.isRemoved()) {
            return;
        }
        for (IEntityEffect e : this.effects) {
            e.tick(this);
        }
    }

    public Collection<IEntityEffect> getEffects() {
        return this.effects;
    }

    public boolean isCurrentPlayer(LivingEntity player) {
        return GameUtils.getPlayer().map(p -> p.getId() == player.getId()).orElse(false);
    }

    public boolean isRemoved() {
        LivingEntity e = (LivingEntity)this.entity.get();
        return e == null || e.isRemoved();
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public static EntityEffectInfo createDefault(int version) {
        return new EntityEffectInfo(version){

            @Override
            public boolean isDefault() {
                return true;
            }

            @Override
            @NotNull
            public LivingEntity getEntity() {
                throw new RuntimeException("No entity associated with default entity effect info");
            }

            @Override
            public void activate() {
            }

            @Override
            public void deactivate() {
            }

            @Override
            public void tick() {
            }

            @Override
            public boolean isCurrentPlayer(LivingEntity player) {
                return false;
            }

            @Override
            public boolean isRemoved() {
                return false;
            }

            @Override
            public boolean isAlive() {
                return true;
            }
        };
    }
}

