/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.HitResult;
import org.orecruncher.dsurround.config.libraries.IItemLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectBase;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.sound.ISoundFactory;

public class ItemSwingEffect
extends EntityEffectBase {
    private final IItemLibrary itemLibrary;
    private boolean isSwinging;

    public ItemSwingEffect(IItemLibrary itemLibrary) {
        this.itemLibrary = itemLibrary;
    }

    @Override
    public void tick(EntityEffectInfo info) {
        boolean isTriggered;
        if (info.isRemoved()) {
            return;
        }
        LivingEntity entity = info.getEntity();
        if (entity.getVehicle() instanceof Boat) {
            return;
        }
        boolean bl = isTriggered = entity.getAttackAnim(1.0f) > 0.0f || ItemSwingEffect.looksToBeBlocking(entity);
        if (isTriggered) {
            if (!this.isSwinging) {
                Object instance;
                ItemStack currentItem = entity.swinging ? entity.getItemInHand(InteractionHand.MAIN_HAND) : entity.getUseItem();
                Optional<ISoundFactory> factory = this.itemLibrary.getItemSwingSound(currentItem);
                if (factory.isPresent() && ItemSwingEffect.freeSwing(entity) && (instance = info.isCurrentPlayer(entity) ? factory.get().createAsAdditional() : factory.get().attachToEntity((Entity)entity)) != null) {
                    this.playSound((SoundInstance)instance);
                }
                this.isSwinging = true;
            }
        } else {
            this.isSwinging = false;
        }
    }

    protected static boolean looksToBeBlocking(LivingEntity entity) {
        if (!entity.isUsingItem() || entity.getUseItem().isEmpty()) {
            return false;
        }
        Item item = entity.getUseItem().getItem();
        return item.getUseAnimation(entity.getUseItem()) == UseAnim.BLOCK;
    }

    protected static boolean freeSwing(LivingEntity entity) {
        HitResult result = ItemSwingEffect.rayTraceBlock(entity);
        return result.getType() == HitResult.Type.MISS;
    }

    protected static double getReach(LivingEntity entity) {
        if (entity instanceof LocalPlayer) {
            LocalPlayer p = (LocalPlayer)entity;
            return p.isCreative() ? 5.0 : 3.0;
        }
        float dist = entity.getBbWidth();
        dist *= 2.0f;
        dist *= dist;
        return dist += entity.getBbWidth();
    }

    protected static HitResult rayTraceBlock(LivingEntity entity) {
        double range = ItemSwingEffect.getReach(entity);
        return entity.pick(range, 1.0f, true);
    }
}

