/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectBase;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.lib.system.ITickCount;
import org.orecruncher.dsurround.mixinutils.ILivingEntityExtended;
import org.orecruncher.dsurround.tags.BlockEffectTags;

public class StepThroughBrushEffect
extends EntityEffectBase {
    private static final long BRUSH_INTERVAL = 2L;
    private static final ResourceLocation BRUSH_SOUND = ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"brush_step/brush");
    private static final ResourceLocation STRAW_SOUND = ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"brush_step/straw");
    private final ITickCount tickCount;
    private final ITagLibrary tagLibrary;
    private long lastBrushCheck;

    public StepThroughBrushEffect(ITickCount tickCount, ITagLibrary tagLibrary) {
        this.tickCount = tickCount;
        this.tagLibrary = tagLibrary;
    }

    @Override
    public void tick(EntityEffectInfo info) {
        long currentCount = this.tickCount.getTickCount();
        if (currentCount > this.lastBrushCheck) {
            BlockPos pos;
            BlockPos feetPos;
            Level world;
            this.lastBrushCheck = currentCount + 2L;
            if (info.isRemoved()) {
                return;
            }
            LivingEntity entity = info.getEntity();
            if (StepThroughBrushEffect.shouldProcess(entity) && !this.process(BlockEffectTags.STRAW_STEP, STRAW_SOUND, world = entity.level(), feetPos = BlockPos.containing((double)(pos = entity.blockPosition()).getX(), (double)((double)pos.getY() + 0.25), (double)pos.getZ()))) {
                this.process(BlockEffectTags.BRUSH_STEP, BRUSH_SOUND, world, feetPos);
            }
        }
    }

    private boolean process(TagKey<Block> effectTag, ResourceLocation factory, Level world, BlockPos blockPos) {
        BlockState block = world.getBlockState(blockPos);
        if (this.tagLibrary.is(effectTag, block)) {
            this.playSoundEffect(blockPos, factory, StepThroughBrushEffect.getVolumeScaling(world, blockPos, block));
            return true;
        }
        BlockPos headPos = blockPos.above();
        block = world.getBlockState(headPos);
        if (this.tagLibrary.is(effectTag, block)) {
            this.playSoundEffect(headPos, factory, StepThroughBrushEffect.getVolumeScaling(world, headPos, block));
            return true;
        }
        return false;
    }

    private static float getVolumeScaling(Level world, BlockPos pos, BlockState state) {
        VoxelShape shape = state.getShape((BlockGetter)world, pos);
        return shape.isEmpty() ? 1.0f : (float)shape.bounds().maxY;
    }

    private static boolean shouldProcess(LivingEntity entity) {
        if (entity.isSilent() || entity.isSpectator()) {
            return false;
        }
        if (entity.xxa != 0.0f || entity.zza != 0.0f || entity.yya != 0.0f) {
            return true;
        }
        return ((ILivingEntityExtended)entity).dsurround_isJumping();
    }

    private void playSoundEffect(BlockPos pos, ResourceLocation factory, float volumeScale) {
        SOUND_LIBRARY.getSoundFactory(factory).ifPresent(f -> {
            SimpleSoundInstance soundInstance = f.createAtLocation(pos, volumeScale);
            this.playSound((SoundInstance)soundInstance);
        });
    }
}

