/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.orecruncher.dsurround.config.libraries.IItemLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectBase;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;

public class ToolbarEffect
extends EntityEffectBase {
    private final IItemLibrary itemLibrary;
    private int lastSlot = -1;

    public ToolbarEffect(IItemLibrary itemLibrary) {
        this.itemLibrary = itemLibrary;
    }

    @Override
    public void tick(EntityEffectInfo info) {
        if (info.isRemoved()) {
            return;
        }
        Player player = (Player)info.getEntity();
        Inventory inventory = player.getInventory();
        if (this.lastSlot == -1) {
            this.lastSlot = inventory.selected;
        } else if (this.lastSlot != inventory.selected) {
            ItemStack currentStack = inventory.getItem(inventory.selected);
            if (!currentStack.isEmpty() & !player.isSpectator()) {
                this.itemLibrary.getItemEquipSound(currentStack).ifPresent(factory -> {
                    Object instance = info.isCurrentPlayer((LivingEntity)player) ? factory.attachToEntity((Entity)player) : factory.createAtLocation((Entity)player);
                    this.playSound((SoundInstance)instance);
                });
            }
            this.lastSlot = inventory.selected;
        }
    }
}

