/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.effects.particles.ParticleUtils;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;

public class FireflyParticle
extends SimpleAnimatedParticle {
    private static final IRandomizer RANDOM = Randomizer.current();
    private static final float XZ_MOTION_DELTA = 0.03f;
    private static final float Y_MOTION_DELTA = 0.015f;
    private static final float ACCELERATION = 5.0E-4f;
    private static final SpriteSet spriteProvider = ParticleUtils.getSpriteProvider(ParticleTypes.END_ROD);
    private final double xAcceleration;
    private final double yAcceleration;
    private final double zAcceleration;

    public FireflyParticle(Level world, double x, double y, double z) {
        super((ClientLevel)world, x, y, z, spriteProvider, 0.0f);
        this.quadSize *= 0.2f + (float)(this.random.nextGaussian() * (double)0.1f);
        this.lifetime = 60 + this.random.nextInt(12);
        this.setColor(ColorPalette.ELECTRIC_GREEN.getValue());
        this.setFadeColor(ColorPalette.LEMON.getValue());
        this.setSpriteFromAge(spriteProvider);
        this.xd = RANDOM.nextGaussian() * (double)0.03f;
        this.yd = RANDOM.nextGaussian() * (double)0.015f;
        this.zd = RANDOM.nextGaussian() * (double)0.03f;
        this.friction = 1.0f;
        this.xAcceleration = RANDOM.nextGaussian() * (double)5.0E-4f;
        this.yAcceleration = RANDOM.nextGaussian() / 2.0 * (double)5.0E-4f;
        this.zAcceleration = RANDOM.nextGaussian() * (double)5.0E-4f;
        this.gravity = 0.0f;
    }

    public int getLightColor(float f) {
        float g = ((float)this.age + f) / (float)this.lifetime;
        g = Mth.clamp((float)g, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(f);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(g * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void move(double dx, double dy, double dz) {
        this.xd += this.xAcceleration;
        this.yd += this.yAcceleration;
        this.zd += this.zAcceleration;
        this.setBoundingBox(this.getBoundingBox().move(this.xd, this.yd, this.zd));
        this.setLocationFromBoundingbox();
    }
}

