/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.effects.particles.ParticleUtils;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;

public class FrostBreathParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;

    public FrostBreathParticle(LivingEntity entity) {
        super((ClientLevel)entity.level(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        float f1;
        IRandomizer rand = Randomizer.current();
        this.spriteProvider = ParticleUtils.getSpriteProvider(ParticleTypes.CLOUD);
        Vec3 origin = ParticleUtils.getBreathOrigin(entity);
        Vec3 trajectory = ParticleUtils.getLookTrajectory(entity);
        this.setPos(origin.x, origin.y, origin.z);
        this.xo = origin.x;
        this.yo = origin.y;
        this.zo = origin.z;
        this.xd = trajectory.x * 0.01;
        this.yd = trajectory.y * 0.01;
        this.zd = trajectory.z * 0.01;
        this.setAlpha(0.2f);
        this.rCol = f1 = 1.0f - (float)(rand.nextDouble() * (double)0.3f);
        this.gCol = f1;
        this.bCol = f1;
        this.quadSize *= 1.875f * (entity.isBaby() ? 0.125f : 0.25f);
        int i = (int)(8.0 / (rand.nextDouble() * 0.8 + 0.3));
        this.lifetime = (int)Math.max((float)i * 2.5f, 1.0f);
        this.hasPhysics = false;
        this.setSpriteFromAge(this.spriteProvider);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public float getSize(float tickDelta) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + tickDelta) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.spriteProvider);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.96f;
            this.yd *= (double)0.96f;
            this.zd *= (double)0.96f;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }
}

