/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;

public final class ParticleRenderCollection<TParticle extends TextureSheetParticle>
extends Particle {
    private final Consumer<Camera> setup;
    private final Supplier<ResourceLocation> textureSupplier;
    private final ObjectArray<TParticle> particles;

    private ParticleRenderCollection(@NotNull ClientLevel clientLevel, @NotNull Supplier<ResourceLocation> textureSupplier, @Nullable Consumer<Camera> setup) {
        super(clientLevel, 0.0, 0.0, 0.0);
        this.setup = Objects.requireNonNullElseGet(setup, () -> this::standardSetup);
        this.textureSupplier = textureSupplier;
        this.particles = new ObjectArray(128);
        this.tick();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void tick() {
        Vec3 playerPos = GameUtils.getPlayer().orElseThrow().getEyePosition();
        this.setPos(playerPos.x(), playerPos.y(), playerPos.z());
        if (!this.particles.isEmpty()) {
            this.particles.forEach(Particle::tick);
            this.particles.removeIf((Predicate<TParticle>)((Predicate<TextureSheetParticle>)p -> !p.isAlive()));
        }
    }

    public void render(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float tickDelta) {
        if (this.particles.isEmpty()) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textureSupplier.get());
        this.setup.accept(camera);
        this.particles.forEach(p -> p.render(vertexConsumer, camera, tickDelta));
    }

    private void standardSetup(@NotNull Camera camera) {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void add(@NotNull TParticle particle) {
        if (particle.getRenderType() != this.getRenderType()) {
            throw new RuntimeException("Can only add render type %s particles to collection".formatted(this.getRenderType()));
        }
        this.particles.add(particle);
    }

    public static final class Helper<TParticle extends TextureSheetParticle> {
        private final String name;
        private final Consumer<Camera> setup;
        private final Supplier<ResourceLocation> textureSupplier;
        private WeakReference<ParticleRenderCollection<TParticle>> particle;
        private String diagnostics;

        public Helper(@NotNull String name, @NotNull Supplier<ResourceLocation> textureSupplier) {
            this(name, textureSupplier, null);
        }

        public Helper(@NotNull String name, @NotNull Supplier<ResourceLocation> textureSupplier, @Nullable Consumer<Camera> setup) {
            this.name = name;
            this.setup = setup;
            this.textureSupplier = textureSupplier;
            this.diagnostics = this.name;
            ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(state -> this.clear());
            ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::collectDiagnostics);
            ClientState.TICK_END.register(this::tick);
        }

        public void add(TParticle particle) {
            this.get().add(particle);
        }

        @NotNull
        private ParticleRenderCollection<TParticle> get() {
            ParticleRenderCollection pc;
            ParticleRenderCollection particleRenderCollection = pc = this.particle != null ? (ParticleRenderCollection)((Object)this.particle.get()) : null;
            if (pc == null || !pc.isAlive()) {
                pc = new ParticleRenderCollection(GameUtils.getWorld().orElseThrow(), this.textureSupplier, this.setup);
                this.particle = new WeakReference(pc);
                GameUtils.getParticleManager().add(pc);
            }
            return pc;
        }

        private void clear() {
            ParticleRenderCollection pc;
            ParticleRenderCollection particleRenderCollection = pc = this.particle != null ? (ParticleRenderCollection)((Object)this.particle.get()) : null;
            if (pc != null) {
                pc.remove();
                this.particle = null;
            }
        }

        private void tick(@NotNull Minecraft client) {
            ParticleRenderCollection pc = this.particle != null ? (ParticleRenderCollection)((Object)this.particle.get()) : null;
            this.diagnostics = this.name + ": ";
            this.diagnostics = pc == null ? this.diagnostics + "Not Set" : (!pc.isAlive() ? this.diagnostics + "DEAD" : this.diagnostics + pc.particles.size());
        }

        private void collectDiagnostics(@NotNull CollectDiagnosticsEvent event) {
            event.add(CollectDiagnosticsEvent.Section.Particles, this.diagnostics);
        }
    }
}

