/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.particles;

import java.util.Optional;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.mixins.core.MixinParticleManager;

public final class ParticleUtils {
    private static final IRandomizer RANDOM = Randomizer.current();

    public static SpriteSet getSpriteProvider(ParticleType<?> particleType) {
        Optional id = RegistryUtils.getRegistry(Registries.PARTICLE_TYPE).map(r -> r.getResourceKey((Object)particleType).map(ResourceKey::location)).orElseThrow();
        return ((MixinParticleManager)GameUtils.getParticleManager()).dsurround_getSpriteAwareFactories().get(id.get());
    }

    public static Vec3 getBreathOrigin(LivingEntity entity) {
        Vec3 eyePosition = ParticleUtils.eyePosition((Entity)entity).subtract(0.0, entity.isBaby() ? 0.1 : 0.2, 0.0);
        Vec3 look = entity.getViewVector(1.0f);
        return eyePosition.add(look.scale(entity.isBaby() ? 0.25 : 0.5));
    }

    public static Vec3 getLookTrajectory(LivingEntity entity) {
        return entity.getLookAngle().zRot(RANDOM.nextFloat() * 2.0f).yRot(RANDOM.nextFloat() * 2.0f).normalize();
    }

    private static Vec3 eyePosition(Entity e) {
        Vec3 y = e.getEyePosition();
        if (e.isCrouching()) {
            y = y.subtract(0.0, 0.25, 0.0);
        }
        return y;
    }
}

