/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.config.WaterRippleStyle;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.gui.ColorPalette;

public class WaterRippleParticle
extends TextureSheetParticle {
    private static final float TEX_SIZE_HALF = 0.5f;
    private static final int BLOCKS_FROM_FADE = 5;
    private static final int MAX_BLOCKS_FADE = 12;
    private final WaterRippleStyle rippleStyle;
    private final float growthRate;
    private final float scaledWidth;
    private float texU1;
    private float texU2;
    private float texV1;
    private float texV2;
    private final float defaultColorAlpha;

    public WaterRippleParticle(WaterRippleStyle rippleStyle, ClientLevel world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.rippleStyle = rippleStyle;
        this.lifetime = rippleStyle.getMaxAge();
        if (rippleStyle.doScaling()) {
            this.quadSize = this.growthRate = (float)this.lifetime / 500.0f;
            this.scaledWidth = this.quadSize * 0.5f;
        } else {
            this.growthRate = 0.0f;
            this.quadSize = 1.0f;
            this.scaledWidth = 0.5f;
        }
        this.y -= 0.2;
        Player player = GameUtils.getPlayer().orElseThrow();
        BlockPos cameraPos = BlockPos.containing((Position)player.getEyePosition(1.0f));
        BlockPos position = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        int colorRgb = ((Biome)this.level.getBiome(position).value()).getWaterColor();
        this.rCol = (float)ColorPalette.getRed(colorRgb) / 255.0f;
        this.gCol = (float)ColorPalette.getGreen(colorRgb) / 255.0f;
        this.bCol = (float)ColorPalette.getBlue(colorRgb) / 255.0f;
        float distance = (float)Mth.clamp((double)(Math.sqrt(cameraPos.distSqr((Vec3i)position)) - 5.0), (double)0.0, (double)12.0);
        this.alpha = this.defaultColorAlpha = 0.6f * (12.0f - distance) / 12.0f;
        this.texU1 = rippleStyle.getU1(this.age);
        this.texU2 = rippleStyle.getU2(this.age);
        this.texV1 = rippleStyle.getV1(this.age);
        this.texV2 = rippleStyle.getV2(this.age);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public float getQuadSize(float tickDelta) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + tickDelta) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    protected float getU0() {
        return this.texU1;
    }

    protected float getU1() {
        return this.texU2;
    }

    protected float getV0() {
        return this.texV1;
    }

    protected float getV1() {
        return this.texV2;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 vec3d = camera.getPosition();
        float X = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - vec3d.x());
        float Y = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - vec3d.y());
        float Z = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - vec3d.z());
        int p = this.getLightColor(tickDelta);
        vertexConsumer.addVertex(-this.scaledWidth + X, Y, this.scaledWidth + Z).setUv(this.texU2, this.texV2).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(p);
        vertexConsumer.addVertex(this.scaledWidth + X, Y, this.scaledWidth + Z).setUv(this.texU2, this.texV1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(p);
        vertexConsumer.addVertex(this.scaledWidth + X, Y, -this.scaledWidth + Z).setUv(this.texU1, this.texV1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(p);
        vertexConsumer.addVertex(-this.scaledWidth + X, Y, -this.scaledWidth + Z).setUv(this.texU1, this.texV2).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(p);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            if (this.rippleStyle.doScaling()) {
                this.quadSize += this.growthRate;
            }
            if (this.rippleStyle.doAlpha()) {
                this.alpha = this.defaultColorAlpha * (float)(this.lifetime - this.age) / (float)this.lifetime;
            }
            this.texU1 = this.rippleStyle.getU1(this.age);
            this.texU2 = this.rippleStyle.getU2(this.age);
            this.texV1 = this.rippleStyle.getV1(this.age);
            this.texV2 = this.rippleStyle.getV2(this.age);
        }
    }
}

