/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.systems;

import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.Constants;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.effects.systems.AbstractEffectSystem;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public class RandomBlockEffectSystem
extends AbstractEffectSystem {
    protected static final IRandomizer RANDOM = Randomizer.current();
    public static final int NEAR_RANGE = 16;
    public static final int FAR_RANGE = 32;
    private static final int ITERATION_COUNT = 667;
    private final IBlockLibrary blockLibrary;
    private final IAudioPlayer audioPlayer;
    private final int range;

    public RandomBlockEffectSystem(IModLog logger, Configuration config, IBlockLibrary blockLibrary, IAudioPlayer audioPlayer, int range) {
        super(logger, config, "Random(%d block range)".formatted(range));
        this.blockLibrary = blockLibrary;
        this.audioPlayer = audioPlayer;
        this.range = range;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void tick(Predicate<IBlockEffect> processingPredicate) {
        super.tick(processingPredicate);
        Player player = GameUtils.getPlayer().orElseThrow();
        Level world = player.level();
        Iterable<BlockPos> iterator = this.iterateRandomly(Randomizer.current(), 667, player.blockPosition(), this.range);
        for (BlockPos blockPos : iterator) {
            BlockInfo info;
            BlockState state;
            if (this.hasSystemAtPosition(blockPos) || Constants.BLOCKS_TO_IGNORE.contains((state = world.getBlockState(blockPos)).getBlock()) || !(info = this.blockLibrary.getBlockInfo(state)).hasSoundsOrEffects()) continue;
            Collection<IBlockEffectProducer> effects = info.getEffectProducers();
            if (!effects.isEmpty()) {
                for (IBlockEffectProducer be : effects) {
                    Optional<IBlockEffect> effect = be.produce(world, state, blockPos, RANDOM);
                    if (!effect.isPresent()) continue;
                    IBlockEffect e = effect.get();
                    this.systems.put(e.getPosIndex(), (Object)e);
                    break;
                }
            }
            info.getSoundToPlay(RANDOM).ifPresent(s -> {
                SimpleSoundInstance instance = s.createAtLocation(blockPos);
                this.audioPlayer.play((SoundInstance)instance);
            });
        }
    }

    @Override
    public void blockScan(Level world, BlockState state, BlockPos pos) {
    }

    protected Iterable<BlockPos> iterateRandomly(final IRandomizer random, final int count, final BlockPos center, final int range) {
        return () -> new AbstractIterator<BlockPos>(this){
            final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int remaining = count;

            protected BlockPos computeNext() {
                if (this.remaining <= 0) {
                    return (BlockPos)this.endOfData();
                }
                --this.remaining;
                return this.pos.set(random.triangle(center.getX(), range), random.triangle(center.getY(), range), random.triangle(center.getZ(), range));
            }
        };
    }
}

