/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.systems;

import java.util.Optional;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.effects.BlockEffectUtils;
import org.orecruncher.dsurround.effects.IEffectSystem;
import org.orecruncher.dsurround.effects.blocks.AbstractParticleEmitterEffect;
import org.orecruncher.dsurround.effects.systems.AbstractEffectSystem;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.tags.BlockEffectTags;

public class SteamEffectSystem
extends AbstractEffectSystem
implements IEffectSystem {
    public SteamEffectSystem(IModLog logger, Configuration config) {
        super(logger, config, "Steam");
    }

    @Override
    public boolean isEnabled() {
        return this.config.blockEffects.steamColumnEnabled;
    }

    @Override
    public void blockScan(Level world, BlockState state, BlockPos pos) {
        if (!this.isEnabled()) {
            return;
        }
        if (SteamEffectSystem.canSteamSpawn(world, state, pos)) {
            if (this.hasSystemAtPosition(pos)) {
                return;
            }
            SteamEffect effect = SteamEffectSystem.getSteamEffect(world, state, pos);
            this.systems.put(pos.asLong(), (Object)effect);
        } else {
            this.blockUnscan(world, state, pos);
        }
    }

    @NotNull
    private static SteamEffect getSteamEffect(Level world, BlockState state, BlockPos pos) {
        FluidState fluidState = state.getFluidState();
        float spawnHeight = fluidState.isEmpty() ? (float)pos.getY() + 0.9f : (float)pos.getY() + fluidState.getOwnHeight() + 0.1f;
        return new SteamEffect(world, (double)pos.getX() + 0.5, spawnHeight, (double)pos.getZ() + 0.5);
    }

    private static boolean canSteamSpawn(Level world, BlockState state, BlockPos pos) {
        return world.getBlockState(pos.above()).isAir() && TAG_LIBRARY.is(BlockEffectTags.STEAM_PRODUCERS, state) && BlockEffectUtils.blockExistsAround(world, pos, BlockEffectUtils.IS_HOT_SOURCE);
    }

    private static class SteamEffect
    extends AbstractParticleEmitterEffect {
        public SteamEffect(Level world, double x, double y, double z) {
            super(world, x, y, z);
            this.age = RANDOM.nextInt(20);
        }

        @Override
        public boolean shouldRemove() {
            if (this.age % 10 == 0) {
                BlockState source = this.world.getBlockState(this.getPos());
                return !SteamEffectSystem.canSteamSpawn(this.world, source, this.getPos());
            }
            return false;
        }

        @Override
        protected Optional<Particle> produceParticle() {
            double VERTICAL_SPEED = 0.08;
            double JITTER = 0.4;
            boolean isSolid = this.world.getBlockState(this.getPos()).getFluidState().isEmpty();
            double x = RANDOM.triangle(this.posX, 0.4);
            double z = RANDOM.triangle(this.posZ, 0.4);
            Optional<Particle> particle = this.createParticle(ParticleTypes.CLOUD, x, this.posY, z, 0.0, 0.08, 0.0);
            particle.ifPresent(p -> {
                p.setLifetime(p.getLifetime() * 2);
                if (isSolid) {
                    p.scale(0.5f);
                    p.setParticleSpeed(0.0, 0.04, 0.0);
                }
            });
            return particle;
        }
    }
}

