/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.systems;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.effects.BlockEffectUtils;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IEffectSystem;
import org.orecruncher.dsurround.effects.blocks.AbstractParticleEmitterEffect;
import org.orecruncher.dsurround.effects.systems.AbstractEffectSystem;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.sound.BackgroundSoundLoop;
import org.orecruncher.dsurround.sound.IAudioPlayer;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundInstanceHandler;
import org.orecruncher.dsurround.tags.FluidTags;

public class WaterfallEffectSystem
extends AbstractEffectSystem
implements IEffectSystem {
    private static final int SOUND_CHECK_INTERVAL = 4;
    private static final int SOUND_INSTANCE_CAP = 32;
    private static final Vec3i[] CARDINAL_OFFSETS = new Vec3i[]{new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1)};
    private static final ISoundFactory[] ACOUSTICS = new ISoundFactory[11];
    private final IAudioPlayer audioPlayer;
    private final Long2ObjectOpenHashMap<BackgroundSoundLoop> waterfallSoundInstances = new Long2ObjectOpenHashMap();
    private long soundCheckThrottle = 0L;

    public WaterfallEffectSystem(IModLog logger, Configuration config) {
        super(logger, config, "Waterfall");
        this.audioPlayer = ContainerManager.resolve(IAudioPlayer.class);
    }

    @Override
    public boolean isEnabled() {
        return this.config.blockEffects.waterfallsEnabled;
    }

    @Override
    public void clear() {
        super.clear();
        this.waterfallSoundInstances.values().forEach(this.audioPlayer::stop);
        this.waterfallSoundInstances.clear();
    }

    @Override
    public void tick(Predicate<IBlockEffect> processingPredicate) {
        super.tick(processingPredicate);
        if (!this.isEnabled() || !this.config.blockEffects.enableWaterfallSounds) {
            if (this.waterfallSoundInstances.isEmpty()) {
                return;
            }
            this.waterfallSoundInstances.values().forEach(this.audioPlayer::stop);
            this.waterfallSoundInstances.clear();
            return;
        }
        if (++this.soundCheckThrottle % 4L != 0L) {
            return;
        }
        Player player = GameUtils.getPlayer().orElseThrow();
        Vec3 eyePosition = player.getEyePosition();
        Set<Long> desiredLocations = this.getDesiredWaterfallSoundLocations();
        for (IBlockEffect system : this.systems.values()) {
            long posIndex = system.getPosIndex();
            WaterfallEffect waterFallEffect = (WaterfallEffect)system;
            BackgroundSoundLoop sound2 = (BackgroundSoundLoop)((Object)this.waterfallSoundInstances.get(posIndex));
            if (desiredLocations.contains(posIndex)) {
                boolean isDone;
                if (sound2 == null) {
                    int idx = Mth.clamp((int)waterFallEffect.getStrength(), (int)0, (int)(ACOUSTICS.length - 1));
                    sound2 = ACOUSTICS[idx].createBackgroundSoundLoopAt(system.getPos());
                    this.waterfallSoundInstances.put(posIndex, (Object)sound2);
                }
                boolean inRange = SoundInstanceHandler.inRange(eyePosition, (SoundInstance)sound2, 4);
                boolean bl = isDone = !this.audioPlayer.isPlaying((SoundInstance)sound2);
                if (inRange && isDone) {
                    this.audioPlayer.play((SoundInstance)sound2);
                    continue;
                }
                if (inRange || isDone) continue;
                this.audioPlayer.stop((SoundInstance)sound2);
                continue;
            }
            if (sound2 == null) continue;
            this.logger.debug("[%s] removing sound instance %s", this.systemName, sound2.toString());
            this.audioPlayer.stop((SoundInstance)sound2);
            this.waterfallSoundInstances.remove(posIndex);
        }
        this.waterfallSoundInstances.values().removeIf(sound -> {
            if (!this.systems.containsKey(sound.getPos().asLong())) {
                this.logger.debug("[%s] Orphan sound removed: %s", this.systemName, sound.toString());
                this.audioPlayer.stop((SoundInstance)sound);
                return true;
            }
            return false;
        });
    }

    protected Set<Long> getDesiredWaterfallSoundLocations() {
        if (!this.config.blockEffects.enableWaterfallSounds || this.systems.isEmpty()) {
            return ImmutableSet.of();
        }
        Player player = GameUtils.getPlayer().orElseThrow();
        if (this.systems.size() <= 32) {
            return this.systems.values().stream().filter(e -> WaterfallEffectSystem.shouldPlaySoundFilter(player.level(), e)).map(IBlockEffect::getPosIndex).collect(Collectors.toSet());
        }
        return this.systems.values().stream().filter(e -> WaterfallEffectSystem.shouldPlaySoundFilter(player.level(), e)).map(e -> {
            WaterfallEffect effect = (WaterfallEffect)e;
            long posIndex = effect.getPosIndex();
            int strength = effect.getStrength();
            Vec3 pos = effect.getPosition();
            double weight = (double)(strength * strength) / player.getEyePosition().distanceToSqr(pos);
            return Pair.of((Object)weight, (Object)posIndex);
        }).sorted((e1, e2) -> -Double.compare((Double)e1.key(), (Double)e2.key())).limit(32L).map(Pair::value).collect(Collectors.toSet());
    }

    private static boolean shouldPlaySoundFilter(Level world, IBlockEffect effect) {
        return TAG_LIBRARY.is(FluidTags.WATERFALL_SOUND, world.getFluidState(effect.getPos()));
    }

    @Override
    public void blockScan(Level world, BlockState state, BlockPos pos) {
        if (WaterfallEffectSystem.canWaterfallSpawn(world, state, pos)) {
            if (this.hasSystemAtPosition(pos)) {
                return;
            }
            WaterfallEffect effect = WaterfallEffectSystem.createWaterfallEffect(world, state, pos);
            this.systems.put(pos.asLong(), (Object)effect);
        } else if (this.hasSystemAtPosition(pos)) {
            this.onRemoveSystem(pos.asLong());
        }
    }

    @Override
    protected void onRemoveSystem(long posLong) {
        super.onRemoveSystem(posLong);
        BackgroundSoundLoop sound = (BackgroundSoundLoop)((Object)this.waterfallSoundInstances.get(posLong));
        if (sound != null) {
            this.audioPlayer.stop((SoundInstance)sound);
            this.waterfallSoundInstances.remove(posLong);
        }
    }

    @NotNull
    private static WaterfallEffect createWaterfallEffect(Level world, BlockState state, BlockPos pos) {
        int strength = BlockEffectUtils.countVerticalBlocks(world, pos, BlockEffectUtils.HAS_FLUID, 1);
        float height = state.getFluidState().getHeight((BlockGetter)world, pos) + 0.1f;
        return new WaterfallEffect(strength, world, pos, (double)height);
    }

    private static boolean canWaterfallSpawn(Level world, BlockState state, BlockPos pos) {
        return TAG_LIBRARY.is(FluidTags.WATERFALL_SOURCE, state.getFluidState()) && WaterfallEffectSystem.isValidWaterfallSource(world, pos);
    }

    private static boolean isValidWaterfallSource(Level world, BlockPos pos) {
        if (world.getFluidState(pos.above()).isEmpty()) {
            return false;
        }
        if (WaterfallEffectSystem.isUnboundedLiquid(world, pos)) {
            BlockPos downPos = pos.below();
            if (world.getBlockState(downPos).isFaceSturdy((BlockGetter)world, downPos, Direction.UP, SupportType.FULL)) {
                return true;
            }
            return WaterfallEffectSystem.isBoundedLiquid(world, pos);
        }
        return false;
    }

    private static boolean isUnboundedLiquid(Level provider, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Vec3i cardinal_offset : CARDINAL_OFFSETS) {
            BlockPos.MutableBlockPos tp = mutable.setWithOffset((Vec3i)pos, cardinal_offset);
            BlockState state = provider.getBlockState((BlockPos)tp);
            if (state.isAir()) {
                return true;
            }
            FluidState fluidState = state.getFluidState();
            int height = fluidState.getAmount();
            if (height <= 0 || height >= 8) continue;
            return true;
        }
        return false;
    }

    private static boolean isBoundedLiquid(Level provider, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Vec3i cardinal_offset : CARDINAL_OFFSETS) {
            BlockPos.MutableBlockPos tp = mutable.setWithOffset((Vec3i)pos, cardinal_offset);
            BlockState state = provider.getBlockState((BlockPos)tp);
            if (state.isAir()) {
                return false;
            }
            FluidState fluidState = state.getFluidState();
            if (fluidState.isEmpty()) continue;
            if (fluidState.hasProperty((Property)FlowingFluid.FALLING)) {
                return false;
            }
            int height = fluidState.getAmount();
            if (height <= 0 || height >= 8) continue;
            return false;
        }
        return true;
    }

    static {
        ISoundLibrary soundLibrary = ContainerManager.resolve(ISoundLibrary.class);
        ISoundFactory factory = soundLibrary.getSoundFactory(ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"waterfalls/0")).orElseThrow();
        Arrays.fill(ACOUSTICS, factory);
        WaterfallEffectSystem.ACOUSTICS[2] = WaterfallEffectSystem.ACOUSTICS[3] = soundLibrary.getSoundFactory(ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"waterfalls/1")).orElseThrow();
        WaterfallEffectSystem.ACOUSTICS[4] = soundLibrary.getSoundFactory(ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"waterfalls/2")).orElseThrow();
        WaterfallEffectSystem.ACOUSTICS[5] = WaterfallEffectSystem.ACOUSTICS[6] = soundLibrary.getSoundFactory(ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"waterfalls/3")).orElseThrow();
        WaterfallEffectSystem.ACOUSTICS[7] = WaterfallEffectSystem.ACOUSTICS[8] = soundLibrary.getSoundFactory(ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"waterfalls/4")).orElseThrow();
        WaterfallEffectSystem.ACOUSTICS[9] = WaterfallEffectSystem.ACOUSTICS[10] = soundLibrary.getSoundFactory(ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"waterfalls/5")).orElseThrow();
    }

    private static class WaterfallEffect
    extends AbstractParticleEmitterEffect {
        private static final Configuration.BlockEffects CONFIG = ContainerManager.resolve(Configuration.BlockEffects.class);
        protected int particleLimit;
        protected final double deltaY;

        public WaterfallEffect(int strength, Level world, BlockPos loc, double dY) {
            super(strength, world, (double)loc.getX() + 0.5, (double)loc.getY() + 0.5, (double)loc.getZ() + 0.5, 4);
            this.deltaY = (double)loc.getY() + dY;
            this.setSpawnCount((int)((float)strength * 2.5f));
        }

        public void setSpawnCount(int limit) {
            this.particleLimit = Mth.clamp((int)limit, (int)5, (int)20);
        }

        @Override
        public boolean shouldRemove() {
            return this.age % 10 == 0 && !WaterfallEffectSystem.canWaterfallSpawn(this.world, this.world.getBlockState(this.position), this.position);
        }

        private int getSplashParticleSpawnCount() {
            int count;
            ParticleStatus state = (ParticleStatus)GameUtils.getGameSettings().particles().get();
            switch (state) {
                case MINIMAL: {
                    int n = 0;
                    break;
                }
                case ALL: {
                    int n = this.particleLimit;
                    break;
                }
                default: {
                    int n = count = this.particleLimit / 2;
                }
            }
            if (count < 4) {
                return count;
            }
            int x = count / 2;
            return RANDOM.nextInt(count - x) + x;
        }

        @Override
        protected void handleParticles() {
            if (!WaterfallEffect.CONFIG.enableWaterfallParticles) {
                return;
            }
            for (int i = 0; i <= this.getSplashParticleSpawnCount(); ++i) {
                this.produceParticle().ifPresent(this::addParticle);
            }
        }

        @Override
        protected Optional<Particle> produceParticle() {
            double xOffset = RANDOM.nextFloat(-1.0f, 1.0f);
            double zOffset = RANDOM.nextFloat(-1.0f, 1.0f);
            double motionStr = (double)(this.strength + 1) / 20.0;
            double motionX = xOffset * motionStr;
            double motionZ = zOffset * motionStr;
            double motionY = 0.1 + (double)RANDOM.nextFloat() * motionStr;
            double posX = this.posX + xOffset;
            double posZ = this.posZ + zOffset;
            Optional<Particle> particle = this.createParticle(ParticleTypes.SPLASH, posX, this.deltaY, posZ, motionX, motionY, motionZ);
            particle.ifPresent(p -> {
                p.setParticleSpeed(motionX, motionY, motionZ);
                p.setLifetime(p.getLifetime() * 2);
            });
            return particle;
        }
    }
}

