/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.eventing;

import java.util.Collection;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.events.EventingFactory;
import org.orecruncher.dsurround.lib.events.IPhasedEvent;

public final class ClientEventHooks {
    public static final IPhasedEvent<ICollectDiagnostics> COLLECT_DIAGNOSTICS = EventingFactory.createPrioritizedEvent(callbacks -> event -> {
        for (ICollectDiagnostics callback : callbacks) {
            callback.onCollect(event);
        }
    });
    public static final IPhasedEvent<IBlockUpdates> BLOCK_UPDATE = EventingFactory.createPrioritizedEvent(callbacks -> blockPositions -> {
        for (IBlockUpdates callback : callbacks) {
            callback.onBlockUpdates(blockPositions);
        }
    });
    public static final IPhasedEvent<IEntityStep> ENTITY_STEP_EVENT = EventingFactory.createPrioritizedEvent(callbacks -> (entity, blockPos, blockState) -> {
        for (IEntityStep callback : callbacks) {
            callback.onStep(entity, blockPos, blockState);
        }
    });
    public static final IPhasedEvent<IFogRender> FOG_RENDER_EVENT = EventingFactory.createPrioritizedEvent(callbacks -> (data, renderDistance, partialTick) -> {
        for (IFogRender callback : callbacks) {
            callback.onRenderFog(data, renderDistance, partialTick);
        }
    });

    @FunctionalInterface
    public static interface IFogRender {
        public void onRenderFog(FogRenderer.FogData var1, float var2, float var3);
    }

    @FunctionalInterface
    public static interface IEntityStep {
        public void onStep(Entity var1, BlockPos var2, BlockState var3);
    }

    @FunctionalInterface
    public static interface IBlockUpdates {
        public void onBlockUpdates(Collection<BlockPos> var1);
    }

    @FunctionalInterface
    public static interface ICollectDiagnostics {
        public void onCollect(CollectDiagnosticsEvent var1);
    }
}

