/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.eventing;

import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.packs.resources.ResourceManager;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.events.EventingFactory;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.events.IPhasedEvent;

public final class ClientState {
    public static final IPhasedEvent<IClientStarted> STARTED = EventingFactory.createPrioritizedEvent(callbacks -> client -> {
        for (IClientStarted callback : callbacks) {
            callback.onStart(client);
        }
    });
    public static final IPhasedEvent<IClientStopping> STOPPING = EventingFactory.createPrioritizedEvent(callbacks -> client -> {
        for (IClientStopping callback : callbacks) {
            callback.onStopping(client);
        }
    });
    public static final IPhasedEvent<IClientTickStart> TICK_START = EventingFactory.createPrioritizedEvent(callbacks -> client -> {
        for (IClientTickStart callback : callbacks) {
            callback.onTickStart(client);
        }
    });
    public static final IPhasedEvent<IClientTickEnd> TICK_END = EventingFactory.createPrioritizedEvent(callbacks -> client -> {
        for (IClientTickEnd callback : callbacks) {
            callback.onTickEnd(client);
        }
    });
    public static final IPhasedEvent<IClientConnect> ON_CONNECT = EventingFactory.createPrioritizedEvent(callbacks -> client -> {
        for (IClientConnect callback : callbacks) {
            callback.onConnect(client);
        }
    });
    public static final IPhasedEvent<IClientDisconnect> ON_DISCONNECT = EventingFactory.createPrioritizedEvent(callbacks -> client -> {
        for (IClientDisconnect callback : callbacks) {
            callback.onDisconnect(client);
        }
    });
    public static final IPhasedEvent<ITagSync> TAG_SYNC = EventingFactory.createPrioritizedEvent(callbacks -> registryAccess -> {
        for (ITagSync callback : callbacks) {
            callback.onTagSync(registryAccess);
        }
    });
    public static final IPhasedEvent<IResourceReload> RESOURCE_RELOAD = EventingFactory.createPrioritizedEvent(callbacks -> registryAccess -> {
        for (IResourceReload callback : callbacks) {
            callback.onResourceReload(registryAccess);
        }
    });
    private static boolean isConnected;

    private ClientState() {
    }

    private static void connectionDetector(Minecraft client) {
        if (isConnected) {
            if (client.player == null) {
                isConnected = false;
                Library.LOGGER.info("Player instance no longer present", new Object[0]);
                ((IClientDisconnect)ON_DISCONNECT.raise()).onDisconnect(client);
            }
        } else if (client.player != null) {
            isConnected = true;
            Library.LOGGER.info("Player instance is now present", new Object[0]);
            ((IClientConnect)ON_CONNECT.raise()).onConnect(client);
        }
    }

    static {
        TICK_START.register(ClientState::connectionDetector, HandlerPriority.VERY_HIGH);
        isConnected = false;
    }

    @FunctionalInterface
    public static interface IClientDisconnect {
        public void onDisconnect(Minecraft var1);
    }

    @FunctionalInterface
    public static interface IClientConnect {
        public void onConnect(Minecraft var1);
    }

    @FunctionalInterface
    public static interface IResourceReload {
        public void onResourceReload(ResourceManager var1);
    }

    @FunctionalInterface
    public static interface ITagSync {
        public void onTagSync(RegistryAccess var1);
    }

    @FunctionalInterface
    public static interface IClientTickEnd {
        public void onTickEnd(Minecraft var1);
    }

    @FunctionalInterface
    public static interface IClientTickStart {
        public void onTickStart(Minecraft var1);
    }

    @FunctionalInterface
    public static interface IClientStopping {
        public void onStopping(Minecraft var1);
    }

    @FunctionalInterface
    public static interface IClientStarted {
        public void onStart(Minecraft var1);
    }
}

