/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.eventing.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.ClientState;

public class BlockUpdateHandler {
    private static final Set<BlockPos> updatedPositions = new HashSet<BlockPos>(16);
    private static final Set<BlockPos> expandedPositions = new HashSet<BlockPos>(48);
    private static final Vec3i[] offsets = new Vec3i[27];

    public static void blockPositionUpdate(BlockPos pos, BlockState oldState, BlockState newState) {
        updatedPositions.add(pos);
    }

    private static void tick(Minecraft ignored) {
        Optional<Collection<BlockPos>> updates = BlockUpdateHandler.expand();
        updates.ifPresent(positions -> ((ClientEventHooks.IBlockUpdates)ClientEventHooks.BLOCK_UPDATE.raise()).onBlockUpdates((Collection<BlockPos>)positions));
    }

    private static Optional<Collection<BlockPos>> expand() {
        if (updatedPositions.isEmpty()) {
            return Optional.empty();
        }
        expandedPositions.clear();
        for (BlockPos center : updatedPositions) {
            for (Vec3i offset : offsets) {
                expandedPositions.add(center.offset(offset));
            }
        }
        updatedPositions.clear();
        return Optional.of(expandedPositions);
    }

    static {
        int x = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockUpdateHandler.offsets[x++] = new Vec3i(i, j, k);
                }
            }
        }
        ClientState.TICK_END.register(BlockUpdateHandler::tick);
    }
}

