/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.keyboard;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.gui.overlay.DiagnosticsOverlay;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlScreen;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.config.IConfigScreenFactoryProvider;
import org.orecruncher.dsurround.lib.config.IScreenFactory;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public class KeyBindings {
    public static final KeyMapping modConfigurationMenu;
    public static final KeyMapping individualSoundConfigBinding;
    public static final KeyMapping diagnosticHud;

    private static KeyMapping registerKeyBinding(String translationKey, int code, String category) {
        KeyMapping mapping = new KeyMapping(translationKey, code, category);
        KeyMappingRegistry.register((KeyMapping)mapping);
        return mapping;
    }

    public static void register() {
        ClientState.TICK_END.register(KeyBindings::handleMenuKeyPress);
    }

    private static void handleMenuKeyPress(Minecraft client) {
        if (GameUtils.getCurrentScreen().isPresent() || GameUtils.getPlayer().isEmpty()) {
            return;
        }
        if (modConfigurationMenu.consumeClick()) {
            IConfigScreenFactoryProvider provider = ContainerManager.resolve(IConfigScreenFactoryProvider.class);
            Optional<IScreenFactory<?>> factory = provider.getModConfigScreenFactory(Configuration.class);
            if (factory.isPresent()) {
                GameUtils.setScreen(factory.get().create(null));
            } else {
                Library.LOGGER.info("Configuration GUI libraries not present", new Object[0]);
            }
        }
        if (diagnosticHud.consumeClick()) {
            ContainerManager.resolve(DiagnosticsOverlay.class).toggleCollection();
        }
        if (individualSoundConfigBinding.consumeClick()) {
            boolean singlePlayer = GameUtils.isSinglePlayer();
            GameUtils.setScreen(new IndividualSoundControlScreen(null, singlePlayer));
            if (singlePlayer) {
                ContainerManager.resolve(IAudioPlayer.class).stopAll();
            }
        }
    }

    static {
        int modMenuKey = Platform.isModLoaded((String)"modmenu") ? InputConstants.UNKNOWN.getValue() : 61;
        modConfigurationMenu = KeyBindings.registerKeyBinding("dsurround.text.keybind.modConfigurationMenu", modMenuKey, "dsurround.text.keybind.section");
        individualSoundConfigBinding = KeyBindings.registerKeyBinding("dsurround.text.keybind.individualSoundConfig", InputConstants.UNKNOWN.getValue(), "dsurround.text.keybind.section");
        diagnosticHud = KeyBindings.registerKeyBinding("dsurround.text.keybind.diagnosticHud", InputConstants.UNKNOWN.getValue(), "dsurround.text.keybind.section");
    }
}

