/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.gui.overlay.AbstractOverlay;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.MinecraftClock;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.gui.ColorGradient;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.tags.ItemEffectTags;

public class ClockOverlay
extends AbstractOverlay {
    private static final int BOTTOM_OFFSET = 88;
    private final ITagLibrary tagLibrary;
    private final ISeasonalInformation seasonalInformation;
    private final Configuration config;
    private final MinecraftClock clock;
    private final ColorGradient gradient;
    private final ObjectArray<Component> clockDisplay = new ObjectArray(2);
    private boolean showClock;
    private int renderWidth;
    private int renderHeight;
    private int color;

    public ClockOverlay(Configuration config, ITagLibrary tagLibrary, ISeasonalInformation seasonalInformation) {
        this.tagLibrary = tagLibrary;
        this.seasonalInformation = seasonalInformation;
        this.config = config;
        this.clock = new MinecraftClock();
        this.gradient = new ColorGradient(ColorPalette.DARK_VIOLET, ColorPalette.SUN_GLOW, 180.0f);
        this.showClock = false;
    }

    @Override
    public void tick(Minecraft client) {
        this.showClock = false;
        if (this.config.compassAndClockOptions.enableClock && GameUtils.isInGame()) {
            int n;
            Player player = GameUtils.getPlayer().orElseThrow();
            ItemStack mainHandItem = player.getMainHandItem();
            ItemStack offHandItem = player.getOffhandItem();
            this.showClock = this.doShowClock(mainHandItem) || this.doShowClock(offHandItem) || this.doShowClock(GameUtils.getMC().crosshairPickEntity);
            this.clock.update(player.level());
            this.clockDisplay.clear();
            this.clockDisplay.add(this.clock.getFormattedTime());
            this.seasonalInformation.getCurrentSeasonTranslated().ifPresent(this.clockDisplay::add);
            Font textRender = GameUtils.getTextRenderer();
            this.renderWidth = textRender.width((FormattedText)this.clockDisplay.get(0));
            if (this.clockDisplay.size() > 1) {
                this.renderWidth = Math.max(this.renderWidth, textRender.width((FormattedText)this.clockDisplay.get(1)));
            }
            if (this.clockDisplay.size() == 1) {
                Objects.requireNonNull(textRender);
                n = 9 - 2;
            } else {
                Objects.requireNonNull(textRender);
                n = 9 * 2;
            }
            this.renderHeight = n;
            Level world = player.level();
            float angleDegrees = world.getTimeOfDay(1.0f) * 360.0f + 180.0f;
            if (angleDegrees >= 360.0f) {
                angleDegrees -= 360.0f;
            }
            if (angleDegrees >= 180.0f) {
                angleDegrees = 360.0f - angleDegrees;
            }
            this.color = this.gradient.getRGBColor(angleDegrees);
        }
    }

    private boolean doShowClock(ItemStack stack) {
        return this.tagLibrary.is(ItemEffectTags.CLOCKS, stack);
    }

    private boolean doShowClock(Entity entity) {
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            ItemStack itemInFrame = frame.getItem();
            return this.doShowClock(itemInFrame);
        }
        return false;
    }

    @Override
    public void render(GuiGraphics context, float partialTick) {
        if (!this.showClock) {
            return;
        }
        Font textRender = GameUtils.getTextRenderer();
        int x = context.guiWidth() / 2;
        int y = context.guiHeight() - 88;
        if (this.clockDisplay.size() == 2) {
            Objects.requireNonNull(textRender);
            y -= 9 / 2;
        }
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)context, (int)(x - this.renderWidth / 2), (int)y, (int)this.renderWidth, (int)this.renderHeight, (int)0);
        context.drawCenteredString(textRender, this.clockDisplay.get(0), x, y, this.color);
        if (this.clockDisplay.size() == 2) {
            Objects.requireNonNull(textRender);
            context.drawCenteredString(textRender, this.clockDisplay.get(1), x, y + 9, this.color);
        }
    }
}

