/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.IDimensionInformation;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.gui.overlay.AbstractOverlay;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.tags.ItemEffectTags;

public class CompassOverlay
extends AbstractOverlay {
    private static final int CROSSHAIR_OFFSET = 60;
    private static final int TEXTURE_SIZE = 512;
    private static final float BAND_WIDTH = 130.0f;
    private static final float BAND_HEIGHT = 24.0f;
    private static final float TEXTURE_SIZE_F = 512.0f;
    private static final int HALF_TEXTURE_SIZE = 256;
    private static final ResourceLocation COMPASS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"textures/compass.png");
    private final ITagLibrary tagLibrary;
    private final IDimensionInformation dimensionInformation;
    private final Configuration config;
    private final CompassWobble wobbler;
    private boolean showCompass;
    private boolean spinRandomly;
    private float scale;
    private float spriteOffset;

    public CompassOverlay(Configuration config, ITagLibrary tagLibrary, IDimensionInformation dimensionInformation) {
        this.tagLibrary = tagLibrary;
        this.dimensionInformation = dimensionInformation;
        this.config = config;
        this.wobbler = new CompassWobble();
        this.showCompass = false;
        this.spriteOffset = this.config.compassAndClockOptions.compassStyle.getSpriteNumber();
        this.scale = (float)this.config.compassAndClockOptions.scale;
    }

    @Override
    public void tick(Minecraft client) {
        this.showCompass = false;
        if (this.config.compassAndClockOptions.enableCompass && GameUtils.isInGame()) {
            this.scale = (float)this.config.compassAndClockOptions.scale;
            this.spriteOffset = this.config.compassAndClockOptions.compassStyle.getSpriteNumber();
            Player player = GameUtils.getPlayer().orElseThrow();
            ItemStack mainHandItem = player.getMainHandItem();
            ItemStack offHandItem = player.getOffhandItem();
            boolean mainHandShow = this.doShowCompass(mainHandItem);
            boolean offHandShow = this.doShowCompass(offHandItem);
            boolean bl = this.showCompass = mainHandShow || offHandShow;
            if (mainHandShow) {
                this.spinRandomly = this.doCompassSpin(mainHandItem);
            }
            if (offHandShow && !this.spinRandomly) {
                this.spinRandomly = this.doCompassSpin(offHandItem);
            }
            this.wobbler.update(player.level().getGameTime());
        }
    }

    private boolean doShowCompass(ItemStack stack) {
        return this.tagLibrary.is(ItemEffectTags.COMPASSES, stack);
    }

    private boolean doCompassSpin(ItemStack stack) {
        return this.dimensionInformation.getCompassWobble() && this.tagLibrary.is(ItemEffectTags.COMPASS_WOBBLE, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(GuiGraphics context, float partialTick) {
        if (!this.showCompass) {
            return;
        }
        PoseStack matrixStack = context.pose();
        try {
            float rotation;
            matrixStack.pushPose();
            if (this.spinRandomly) {
                rotation = this.wobbler.getRandomlySpinningRotation(partialTick);
            } else {
                Player player = GameUtils.getPlayer().orElseThrow();
                rotation = player.getViewYRot(partialTick);
            }
            int direction = Mth.floor((double)((double)(rotation * 512.0f / 360.0f) + 0.5)) & 0x1FF;
            float x = ((float)context.guiWidth() - 130.0f * this.scale) / 2.0f;
            float y = ((float)(context.guiHeight() - 60) - 24.0f * this.scale) / 2.0f;
            matrixStack.scale(this.scale, this.scale, 0.0f);
            x /= this.scale;
            y /= this.scale;
            float v = this.spriteOffset * 48.0f;
            if (direction >= 256) {
                direction -= 256;
                v += 24.0f;
            }
            this.drawTexture(matrixStack, COMPASS_TEXTURE, x, y, direction, v, 130.0f, 24.0f);
        }
        finally {
            matrixStack.popPose();
        }
    }

    public void drawTexture(PoseStack stack, ResourceLocation texture, float x, float y, float u, float v, float width, float height) {
        this.drawTexture(stack, texture, x, x + width, y, y + height, width, height, u, v);
    }

    void drawTexture(PoseStack stack, ResourceLocation texture, float x1, float x2, float y1, float y2, float regionWidth, float regionHeight, float u, float v) {
        this.drawTexturedQuad(stack, texture, x1, x2, y1, y2, 0.0f, u / 512.0f, (u + regionWidth) / 512.0f, v / 512.0f, (v + regionHeight) / 512.0f);
    }

    void drawTexturedQuad(PoseStack stack, ResourceLocation texture, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = stack.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, x1, y1, z).setUv(u1, v1);
        bufferBuilder.addVertex(matrix4f, x1, y2, z).setUv(u1, v2);
        bufferBuilder.addVertex(matrix4f, x2, y2, z).setUv(u2, v2);
        bufferBuilder.addVertex(matrix4f, x2, y1, z).setUv(u2, v1);
        MeshData mesh = bufferBuilder.build();
        if (mesh != null) {
            BufferUploader.drawWithShader((MeshData)mesh);
        }
    }

    static class CompassWobble {
        private static int TICK_DELAY = 5;
        private static float MAX_DELTA_TICK = 0.05f;
        private float targetRotation;
        private float lastRotation;
        private float rotation;
        private float rotationStep;
        private long lastUpdateTick;
        private int tickWait;

        CompassWobble() {
        }

        public float getRandomlySpinningRotation(float partialTick) {
            return Mth.lerp((float)partialTick, (float)this.lastRotation, (float)this.rotation) * 360.0f;
        }

        public void update(long tickCount) {
            if (this.lastUpdateTick != tickCount) {
                this.updateRotation(tickCount);
            }
        }

        private void updateRotation(long tickCount) {
            this.lastUpdateTick = tickCount;
            this.lastRotation = this.rotation;
            if (this.rotation < this.targetRotation) {
                this.rotation += this.rotationStep;
                if (this.rotation > this.targetRotation) {
                    this.rotation = this.targetRotation;
                }
            } else if (this.rotation > this.targetRotation) {
                this.rotation -= this.rotationStep;
                if (this.rotation < this.targetRotation) {
                    this.rotation = this.targetRotation;
                }
            }
            if (this.rotation == this.targetRotation) {
                if (this.tickWait < 0) {
                    this.tickWait = Randomizer.current().nextInt(TICK_DELAY);
                } else if (--this.tickWait == 0) {
                    this.targetRotation = Randomizer.current().nextFloat();
                    this.rotationStep = MAX_DELTA_TICK;
                }
            }
        }
    }
}

