/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay.plugins;

import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.gui.overlay.IDiagnosticPlugin;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.math.ITimer;
import org.orecruncher.dsurround.lib.math.TimerEMA;

public class ClientProfilerPlugin
implements IDiagnosticPlugin {
    private final TimerEMA clientTick = new TimerEMA("Client Tick");
    private final TimerEMA lastTick = new TimerEMA("Last Tick");
    private long lastTickMark = -1L;
    private long timeMark = 0L;
    private float tps = 0.0f;

    public ClientProfilerPlugin() {
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::onCollect, HandlerPriority.VERY_HIGH);
        ClientState.TICK_START.register(this::tickStart, HandlerPriority.VERY_HIGH);
        ClientState.TICK_END.register(this::tickEnd, HandlerPriority.VERY_LOW);
    }

    private void tickStart(Minecraft client) {
        this.timeMark = System.nanoTime();
        if (this.lastTickMark != -1L) {
            this.lastTick.update(this.timeMark - this.lastTickMark);
            this.tps = Mth.clamp((float)((float)(50.0 / this.lastTick.getMSecs() * 20.0)), (float)0.0f, (float)20.0f);
        }
        this.lastTickMark = this.timeMark;
    }

    private void tickEnd(Minecraft client) {
        long delta = System.nanoTime() - this.timeMark;
        this.clientTick.update(delta);
    }

    @Override
    public void onCollect(CollectDiagnosticsEvent event) {
        ITimer tpsTimer = new ITimer(){

            @Override
            public double getMSecs() {
                return ClientProfilerPlugin.this.tps;
            }

            @Override
            public String toString() {
                return String.format("Client TPS:%7.3fms", this.getMSecs());
            }
        };
        event.add(tpsTimer);
        event.add(this.clientTick);
        event.add(this.lastTick);
    }
}

