/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay.plugins;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.gui.overlay.IDiagnosticPlugin;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.MinecraftClock;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.mixinutils.IMusicManager;
import org.orecruncher.dsurround.runtime.IConditionEvaluator;

public class RuntimeDiagnosticsPlugin
implements IDiagnosticPlugin {
    private static final List<String> scripts = ImmutableList.of((Object)"'Dim: ' + dim.getId() + '/' + dim.getDimName() + '; isSuperFlat: ' + dim.isSuperFlat()", (Object)"'Biome: ' + biome.getName() + ' (' + biome.getId() + '); Temp ' + biome.getTemperature() + '; rainfall: ' + biome.getRainfall()", (Object)"'Biome Traits: ' + biome.getTraits()", (Object)"'Weather: ' + lib.iif(weather.isRaining(),'rain: ' + weather.getRainIntensity(),'not raining') + lib.iif(weather.isThundering(),' thundering','') + '; Temp: ' + weather.getTemperature() + '; ice: ' + lib.iif(weather.getTemperature() < 0.15, 'true', 'false') + ' ' + lib.iif(weather.getTemperature() < 0.2, '(breath)', '')", (Object)"'Diurnal: ' + lib.iif(diurnal.isNight(),' night,',' day,') + '; celestial angle: ' + diurnal.getCelestialAngle() + '; degrees: ' + (diurnal.getCelestialAngle()*360)", (Object)"'Player: health ' + player.getHealth() + '/' + player.getMaxHealth() + '; food ' + player.getFoodLevel() + '/' + player.getFoodSaturationLevel() + '; pos (' + player.getX() + ', ' + player.getY() + ', ' + player.getZ() + ')'", (Object)"'State: isInside ' + state.isInside() + '; inVillage ' + state.isInVillage() + '; isUnderWater ' + state.isUnderWater()");
    private final MinecraftClock clock = new MinecraftClock();
    private final IConditionEvaluator conditionEvaluator;
    private final ISeasonalInformation seasonalInformation;

    public RuntimeDiagnosticsPlugin(IConditionEvaluator conditionEvaluator, ISeasonalInformation seasonalInformation) {
        this.conditionEvaluator = conditionEvaluator;
        this.seasonalInformation = seasonalInformation;
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::onCollect, HandlerPriority.HIGH);
    }

    @Override
    public void onCollect(CollectDiagnosticsEvent event) {
        if (GameUtils.isInGame()) {
            ClientLevel world = GameUtils.getWorld().orElseThrow();
            this.clock.update((Level)world);
            event.add(CollectDiagnosticsEvent.Section.Header, this.clock.getFormattedTime());
            Component seasonInfo = this.seasonalInformation.getCurrentSeasonTranslated().orElse((Component)Component.literal((String)"UNKNOWN"));
            MutableComponent seasonText = Component.translatable((String)"Season: %s (%s)", (Object[])new Object[]{seasonInfo, this.seasonalInformation.getProviderName()});
            event.add(CollectDiagnosticsEvent.Section.Header, (Component)seasonText);
            String particleLoad = "Particle Manager: %s".formatted(GameUtils.getParticleManager().countParticles());
            event.add(CollectDiagnosticsEvent.Section.Systems, particleLoad);
            String musicManager = ((IMusicManager)GameUtils.getMC().getMusicManager()).dsurround_getDiagnosticText();
            event.add(CollectDiagnosticsEvent.Section.Systems, musicManager);
            for (String script : scripts) {
                Object result = this.conditionEvaluator.eval(new Script(script));
                event.add(CollectDiagnosticsEvent.Section.Environment, result.toString());
            }
        }
    }
}

