/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay.plugins;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.gui.overlay.IDiagnosticPlugin;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.mixins.audio.MixinSoundEngineAccessor;
import org.orecruncher.dsurround.mixins.audio.MixinSoundManagerAccessor;

public class SoundEngineDiagnosticsPlugin
implements IDiagnosticPlugin {
    private static final String FMT_DBG_SOUND = "%s: %d";

    public SoundEngineDiagnosticsPlugin() {
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::onCollect, HandlerPriority.LOW);
    }

    @Override
    public void onCollect(CollectDiagnosticsEvent event) {
        SoundManager soundManager = GameUtils.getSoundManager();
        Collection<Component> panelText = event.getSectionText(CollectDiagnosticsEvent.Section.Sounds);
        for (SoundSource category : SoundSource.values()) {
            float volumeSettings = GameUtils.getGameSettings().getSoundSourceVolume(category);
            if (Float.compare(volumeSettings, 0.0f) != 0) continue;
            MutableComponent text = Component.literal((String)"%s is OFF".formatted(category.name())).withColor(ColorPalette.RED.getValue());
            panelText.add((Component)text);
        }
        MixinSoundManagerAccessor manager = (MixinSoundManagerAccessor)soundManager;
        MixinSoundEngineAccessor accessors = (MixinSoundEngineAccessor)manager.dsurround_getSoundSystem();
        Map<SoundInstance, ChannelAccess.ChannelHandle> sources = accessors.dsurround_getSources();
        MutableComponent str = Component.literal((String)soundManager.getDebugString());
        panelText.add((Component)str);
        if (!sources.isEmpty()) {
            accessors.dsurround_getSources().keySet().stream().map(SoundInstance::getLocation).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(e -> FMT_DBG_SOUND.formatted(e.getKey(), e.getValue())).sorted().map(Component::literal).forEach(panelText::add);
        } else {
            panelText.add((Component)Component.literal((String)"No sounds playing"));
        }
    }
}

