/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay.plugins;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.config.libraries.IEntityEffectLibrary;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.gui.overlay.IDiagnosticPlugin;
import org.orecruncher.dsurround.lib.Comparers;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;

public class ViewerPlugin
implements IDiagnosticPlugin {
    private static final Object2ObjectOpenHashMap<String, Style> TAG_STYLES = new Object2ObjectOpenHashMap();
    private final Configuration.Logging config;
    private final IBlockLibrary blockLibrary;
    private final ITagLibrary tagLibrary;
    private final IEntityEffectLibrary entityEffectLibrary;

    public ViewerPlugin(Configuration.Logging config, IBlockLibrary blockLibrary, ITagLibrary tagLibrary, IEntityEffectLibrary entityEffectLibrary) {
        this.config = config;
        this.blockLibrary = blockLibrary;
        this.tagLibrary = tagLibrary;
        this.entityEffectLibrary = entityEffectLibrary;
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::onCollect);
    }

    private void processBlockHitResult(Level world, BlockHitResult result, Collection<Component> data) {
        if (result.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockState state = world.getBlockState(result.getBlockPos());
        data.add((Component)Component.literal((String)state.toString()));
        this.processTags(state.getBlockHolder(), data);
        if (!state.getFluidState().isEmpty()) {
            data.add((Component)Component.literal((String)"Fluid Tags"));
            this.processTags(state.getFluidState().holder(), data);
        }
        BlockInfo info = this.blockLibrary.getBlockInfo(state);
        String wallOfText = info.toString();
        Arrays.stream(wallOfText.split("\n")).map(l -> l.replaceAll("[\\[\\]]", "").strip()).filter(s -> !Strings.isNullOrEmpty((String)s)).map(Component::literal).forEach(data::add);
    }

    private void processEntityHitResult(Entity entity, Collection<Component> data) {
        data.add((Component)Component.literal((String)String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()))));
        Optional<Holder.Reference<EntityType>> holderResult = RegistryUtils.getRegistryEntry(Registries.ENTITY_TYPE, entity.getType());
        if (holderResult.isEmpty()) {
            return;
        }
        this.processTags((Holder)holderResult.get(), data);
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            EntityEffectInfo info = this.entityEffectLibrary.getEntityEffectInfo(le);
            if (info.isDefault()) {
                data.add((Component)Component.literal((String)"Default Effects"));
            } else {
                info.getEffects().forEach(effect -> data.add((Component)Component.literal((String)effect.toString())));
            }
        } else {
            data.add((Component)Component.literal((String)"Not a LivingEntity"));
        }
    }

    private void processHeldItem(ItemStack stack, Collection<Component> data) {
        if (stack.isEmpty()) {
            return;
        }
        Holder holder = stack.getItemHolder();
        holder.unwrapKey().ifPresent(key -> data.add((Component)Component.literal((String)key.location().toString())));
        this.processTags(holder, data);
    }

    private <T> void processTags(Holder<T> holder, Collection<Component> data) {
        Stream<ResourceLocation> query = this.tagLibrary.streamTags(holder).map(TagKey::location);
        if (this.config.filteredTagView) {
            query = query.filter(loc -> TAG_STYLES.containsKey((Object)loc.getNamespace()));
        }
        query.sorted(Comparers.IDENTIFIER_NATURAL_COMPARABLE).map(l -> {
            Style formatting = (Style)TAG_STYLES.get((Object)l.getNamespace());
            return Component.literal((String)("#" + String.valueOf(l))).withStyle(formatting);
        }).forEach(data::add);
    }

    @Override
    public void onCollect(CollectDiagnosticsEvent event) {
        LivingEntity le;
        ItemStack stack;
        Entity entity = GameUtils.getMC().getCameraEntity();
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity && !(stack = (le = (LivingEntity)entity).getItemInHand(InteractionHand.MAIN_HAND)).isEmpty()) {
            Collection<Component> panelText = event.getSectionText(CollectDiagnosticsEvent.Section.HeldItem);
            this.processHeldItem(stack, panelText);
        }
        BlockHitResult blockHit = (BlockHitResult)entity.pick(20.0, 0.0f, false);
        BlockHitResult fluidHit = (BlockHitResult)entity.pick(20.0, 0.0f, true);
        Entity entityHit = GameUtils.getMC().crosshairPickEntity;
        Collection<Component> panelText = event.getSectionText(CollectDiagnosticsEvent.Section.BlockView);
        this.processBlockHitResult(entity.level(), blockHit, panelText);
        if (!blockHit.getBlockPos().equals((Object)fluidHit.getBlockPos())) {
            panelText = event.getSectionText(CollectDiagnosticsEvent.Section.FluidView);
            this.processBlockHitResult(entity.level(), fluidHit, panelText);
        }
        if (entityHit != null) {
            panelText = event.getSectionText(CollectDiagnosticsEvent.Section.EntityView);
            this.processEntityHitResult(entityHit, panelText);
        }
    }

    static {
        TAG_STYLES.defaultReturnValue((Object)Style.EMPTY.withColor(ColorPalette.GRAY));
        TAG_STYLES.put((Object)"dsurround", (Object)Style.EMPTY.withColor(ColorPalette.GOLD));
        TAG_STYLES.put((Object)"minecraft", (Object)Style.EMPTY.withColor(ColorPalette.FRESH_AIR));
        TAG_STYLES.put((Object)"forge", (Object)Style.EMPTY.withColor(ColorPalette.AQUAMARINE));
        TAG_STYLES.put((Object)"fabric", (Object)Style.EMPTY.withColor(ColorPalette.CORNSILK));
        TAG_STYLES.put((Object)"c", (Object)Style.EMPTY.withColor(ColorPalette.CORNSILK));
    }
}

