/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlListEntry;
import org.orecruncher.dsurround.lib.di.ContainerManager;

public class IndividualSoundControlList
extends AbstractSelectionList<IndividualSoundControlListEntry> {
    private final Screen parent;
    private final boolean enablePlay;
    private final ISoundLibrary soundLibrary = ContainerManager.resolve(ISoundLibrary.class);
    private int width;
    private List<IndividualSoundConfigEntry> source;
    private String lastSearchText = null;

    public IndividualSoundControlList(Screen parent, Minecraft mcIn, int widthIn, int heightIn, int topIn, int slotWidth, int slotHeightIn, boolean enablePlay, Supplier<String> filter, @Nullable IndividualSoundControlList oldList) {
        super(mcIn, widthIn, heightIn, topIn, slotHeightIn);
        this.parent = parent;
        this.enablePlay = enablePlay;
        this.width = slotWidth;
        if (oldList != null) {
            this.source = oldList.source;
            this.calculateRowWidth();
        }
        this.setSearchFilter(filter);
    }

    public int getRowWidth() {
        return this.width;
    }

    public void setRowWidth(int width) {
        this.width = width - 40;
        this.children().forEach(c -> c.setWidth(this.width));
    }

    protected int getScrollbarPosition() {
        return (this.parent.width + this.getRowWidth()) / 2 + 20;
    }

    public void setSearchFilter(Supplier<String> filterBy) {
        String filter = filterBy.get();
        if (this.lastSearchText != null && this.lastSearchText.equals(filter)) {
            return;
        }
        this.lastSearchText = filter;
        this.clearEntries();
        if (this.source == null) {
            this.source = new ArrayList<IndividualSoundConfigEntry>(this.getSortedSoundConfigurations());
            this.calculateRowWidth();
        }
        Predicate<IndividualSoundConfigEntry> process = StringUtils.isEmpty((CharSequence)filter) ? isc -> true : isc -> isc.soundEventIdProjected.contains(filter);
        IndividualSoundControlListEntry first = null;
        for (IndividualSoundConfigEntry cfg : this.source) {
            if (!process.test(cfg)) continue;
            IndividualSoundControlListEntry entry = new IndividualSoundControlListEntry(cfg, this.enablePlay);
            if (first == null) {
                first = entry;
            }
            this.addEntry((AbstractSelectionList.Entry)entry);
        }
        this.calculateRowWidth();
        if (first != null) {
            this.ensureVisible((AbstractSelectionList.Entry)first);
        }
    }

    @Nullable
    public IndividualSoundControlListEntry getEntryAt(int mouseX, int mouseY) {
        return (IndividualSoundControlListEntry)this.getEntryAtPosition(mouseX, mouseY);
    }

    public void tick() {
        this.children().forEach(IndividualSoundControlListEntry::tick);
    }

    protected Collection<IndividualSoundConfigEntry> getConfigs() {
        ArrayList<IndividualSoundConfigEntry> configs = new ArrayList<IndividualSoundConfigEntry>();
        for (IndividualSoundConfigEntry cfg : this.source) {
            if (!cfg.isNotDefault()) continue;
            configs.add(cfg);
        }
        return configs;
    }

    public void saveChanges() {
        this.soundLibrary.saveIndividualSoundConfigs(this.getConfigs());
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput builder) {
    }

    protected Collection<IndividualSoundConfigEntry> getSortedSoundConfigurations() {
        HashMap<ResourceLocation, IndividualSoundConfigEntry> map = new HashMap<ResourceLocation, IndividualSoundConfigEntry>();
        for (SoundEvent event : this.soundLibrary.getRegisteredSoundEvents()) {
            IndividualSoundConfigEntry entry = IndividualSoundConfigEntry.createDefault(event);
            map.put(entry.soundEventId, entry);
        }
        for (IndividualSoundConfigEntry entry : this.soundLibrary.getIndividualSoundConfigs()) {
            map.put(entry.soundEventId, entry);
        }
        return map.values().stream().sorted(IndividualSoundConfigEntry::compareTo).collect(Collectors.toList());
    }

    protected void calculateRowWidth() {
        if (!this.children().isEmpty()) {
            Optional<Integer> width = this.children().stream().map(IndividualSoundControlListEntry::getWidth).max(Integer::compareTo);
            width.ifPresent(w -> {
                this.width = w;
            });
        }
    }
}

