/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.gui.sound.BlockButton;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.gui.sound.CullButton;
import org.orecruncher.dsurround.gui.sound.SoundPlayButton;
import org.orecruncher.dsurround.gui.sound.VolumeSliderControl;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.gui.GuiHelpers;
import org.orecruncher.dsurround.lib.gui.TextWidget;
import org.orecruncher.dsurround.lib.platform.ModInformation;
import org.orecruncher.dsurround.sound.IAudioPlayer;
import org.orecruncher.dsurround.sound.SoundMetadata;

public class IndividualSoundControlListEntry
extends ContainerObjectSelectionList.Entry<IndividualSoundControlListEntry>
implements AutoCloseable {
    private static final ISoundLibrary SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);
    private static final IAudioPlayer AUDIO_PLAYER = ContainerManager.resolve(IAudioPlayer.class);
    private static final int TOOLTIP_WIDTH = 300;
    private static final Style STYLE_MOD_NAME = Style.EMPTY.withColor(ColorPalette.GOLD);
    private static final Style STYLE_ID = Style.EMPTY.withColor(ColorPalette.SLATEGRAY);
    private static final Style STYLE_CATEGORY = Style.EMPTY.withColor(ColorPalette.FRESH_AIR);
    private static final Style STYLE_SUBTITLE = Style.EMPTY.withColor(ColorPalette.APRICOT).withItalic(Boolean.valueOf(true));
    private static final Style STYLE_CREDIT_NAME = Style.EMPTY.withColor(ColorPalette.GREEN);
    private static final Style STYLE_CREDIT_AUTHOR = Style.EMPTY.withColor(ColorPalette.WHITE);
    private static final Style STYLE_CREDIT_LICENSE = Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ColorPalette.MC_DARKAQUA);
    private static final Style STYLE_HELP = Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ColorPalette.KEY_LIME);
    private static final FormattedCharSequence VANILLA_CREDIT = Component.translatable((String)"dsurround.text.soundconfig.vanilla").getVisualOrderText();
    private static final Collection<Component> VOLUME_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.volume.help", 300, STYLE_HELP);
    private static final Collection<Component> PLAY_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.play.help", 300, STYLE_HELP);
    private static final Collection<Component> CULL_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.cull.help", 300, STYLE_HELP);
    private static final Collection<Component> BLOCK_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.block.help", 300, STYLE_HELP);
    private static final int CONTROL_SPACING = 3;
    private final IndividualSoundConfigEntry config;
    private final TextWidget label;
    private final VolumeSliderControl volume;
    private final BlockButton blockButton;
    private final CullButton cullButton;
    @Nullable
    private final SoundPlayButton playButton;
    private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    private final List<FormattedCharSequence> cachedToolTip = new ArrayList<FormattedCharSequence>();
    private ConfigSoundInstance soundPlay;

    public IndividualSoundControlListEntry(IndividualSoundConfigEntry data, boolean enablePlay) {
        this.config = data;
        Objects.requireNonNull(GameUtils.getTextRenderer());
        this.label = new TextWidget(0, 0, 200, 9, (Component)Component.literal((String)data.soundEventId.toString()), GameUtils.getTextRenderer());
        this.children.add((AbstractWidget)this.label);
        this.volume = new VolumeSliderControl(this, 0, 0);
        this.children.add((AbstractWidget)this.volume);
        this.blockButton = new BlockButton(this.config.block, this::toggleBlock);
        this.children.add((AbstractWidget)this.blockButton);
        this.cullButton = new CullButton(this.config.cull, this::toggleCull);
        this.children.add((AbstractWidget)this.cullButton);
        if (enablePlay) {
            this.playButton = new SoundPlayButton(this::play);
            this.children.add((AbstractWidget)this.playButton);
        } else {
            this.playButton = null;
        }
    }

    public int getWidth() {
        int width = this.label.getWidth();
        width += this.cullButton.getWidth() + this.blockButton.getWidth() + this.volume.getWidth() + 12;
        if (this.playButton != null) {
            width += this.playButton.getWidth() + 3;
        }
        return width;
    }

    public void setWidth(int width) {
        int fixedWidth = this.cullButton.getWidth() + this.blockButton.getWidth() + this.volume.getWidth() + 12;
        if (this.playButton != null) {
            fixedWidth += this.playButton.getWidth() + 3;
        }
        if ((width -= fixedWidth) < 100) {
            width = 100;
        }
        this.label.setWidth(width);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        AbstractWidget child = this.findChild(mouseX, mouseY);
        if (child != null) {
            child.mouseMoved(mouseX, mouseY);
        }
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AbstractWidget child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    @NotNull
    public List<? extends NarratableEntry> narratables() {
        return ImmutableList.of();
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        AbstractWidget child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        AbstractWidget child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hAmount, double vAmount) {
        AbstractWidget child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.mouseScrolled(mouseX, mouseY, hAmount, vAmount);
        }
        return false;
    }

    private AbstractWidget findChild(double mouseX, double mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            for (AbstractWidget e : this.children) {
                if (!e.isMouseOver(mouseX, mouseY)) continue;
                return e;
            }
        }
        return null;
    }

    public void render(@NotNull GuiGraphics context, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick_) {
        Font font = GameUtils.getTextRenderer();
        Objects.requireNonNull(font);
        int labelY = rowTop + (rowHeight - 9) / 2;
        this.label.setX(rowLeft);
        this.label.setY(labelY);
        int rightMargin = rowLeft + rowWidth;
        this.volume.setX(rightMargin - this.volume.getWidth());
        this.volume.setY(rowTop);
        this.volume.setHeight(rowHeight);
        rightMargin -= this.volume.getWidth() + 3;
        if (this.playButton != null) {
            this.playButton.setX(rightMargin - this.playButton.getWidth());
            this.playButton.setY(rowTop);
            this.playButton.setHeight(rowHeight);
            rightMargin -= this.playButton.getWidth() + 3;
        }
        this.blockButton.setX(rightMargin - this.blockButton.getWidth());
        this.blockButton.setY(rowTop);
        this.blockButton.setHeight(rowHeight);
        this.cullButton.setX((rightMargin -= this.blockButton.getWidth() + 3) - this.cullButton.getWidth());
        this.cullButton.setHeight(rowHeight);
        this.cullButton.setY(rowTop);
        for (AbstractWidget w : this.children) {
            w.render(context, mouseX, mouseY, partialTick_);
        }
    }

    protected void toggleBlock(Button button) {
        if (button instanceof BlockButton) {
            BlockButton bb = (BlockButton)button;
            this.config.block = bb.toggle();
        }
    }

    protected void toggleCull(Button button) {
        if (button instanceof CullButton) {
            CullButton cb = (CullButton)button;
            this.config.cull = cb.toggle();
        }
    }

    protected void play(Button button) {
        if (button instanceof SoundPlayButton) {
            SoundPlayButton sp = (SoundPlayButton)button;
            if (this.soundPlay == null) {
                this.soundPlay = this.playSound(this.config);
                sp.play();
            } else {
                AUDIO_PLAYER.stop((SoundInstance)this.soundPlay);
                this.soundPlay = null;
                sp.stop();
            }
        }
    }

    protected ConfigSoundInstance playSound(IndividualSoundConfigEntry entry) {
        SoundMetadata metadata = SOUND_LIBRARY.getSoundMetadata(entry.soundEventId);
        ConfigSoundInstance sound = ConfigSoundInstance.create(entry.soundEventId, metadata.getCategory(), () -> Float.valueOf((float)entry.volumeScale / 100.0f));
        AUDIO_PLAYER.play((SoundInstance)sound);
        return sound;
    }

    @Override
    public void close() {
        if (this.soundPlay != null) {
            AUDIO_PLAYER.stop((SoundInstance)this.soundPlay);
            this.soundPlay = null;
        }
    }

    public void tick() {
        if (this.soundPlay != null && this.playButton != null && !AUDIO_PLAYER.isPlaying((SoundInstance)this.soundPlay)) {
            this.soundPlay = null;
            this.playButton.stop();
        }
    }

    protected List<FormattedCharSequence> getToolTip(int mouseX, int mouseY) {
        if (this.cachedToolTip.isEmpty()) {
            ResourceLocation id = this.config.soundEventId;
            this.resolveDisplayName(id.getNamespace()).ifPresent(name -> {
                FormattedCharSequence modName = FormattedCharSequence.forward((String)Objects.requireNonNull(ChatFormatting.stripFormatting((String)name)), (Style)STYLE_MOD_NAME);
                this.cachedToolTip.add(modName);
            });
            FormattedCharSequence soundLocationId = FormattedCharSequence.forward((String)id.toString(), (Style)STYLE_ID);
            this.cachedToolTip.add(soundLocationId);
            SoundMetadata metadata = SOUND_LIBRARY.getSoundMetadata(id);
            if (metadata != null) {
                if (!metadata.getTitle().equals((Object)Component.empty())) {
                    this.cachedToolTip.add(metadata.getTitle().getVisualOrderText());
                }
                this.cachedToolTip.add(Component.literal((String)metadata.getCategory().toString()).withStyle(STYLE_CATEGORY).getVisualOrderText());
                if (!metadata.getSubTitle().equals((Object)Component.empty())) {
                    this.cachedToolTip.add(metadata.getSubTitle().copy().withStyle(STYLE_SUBTITLE).getVisualOrderText());
                }
                if (!metadata.getCredits().isEmpty()) {
                    for (SoundMetadata.Credit credit : metadata.getCredits()) {
                        this.cachedToolTip.add(Component.empty().getVisualOrderText());
                        this.cachedToolTip.add(credit.name().copy().withStyle(STYLE_CREDIT_NAME).getVisualOrderText());
                        this.cachedToolTip.add(credit.author().copy().withStyle(STYLE_CREDIT_AUTHOR).getVisualOrderText());
                        if (credit.webSite().isPresent()) {
                            this.cachedToolTip.add(credit.webSite().get().copy().withStyle(STYLE_CREDIT_AUTHOR).getVisualOrderText());
                        }
                        this.cachedToolTip.add(credit.license().copy().withStyle(STYLE_CREDIT_LICENSE).getVisualOrderText());
                    }
                }
            }
            if (id.getNamespace().equals("minecraft")) {
                this.cachedToolTip.add(VANILLA_CREDIT);
            }
        }
        ArrayList<FormattedCharSequence> generatedTip = new ArrayList<FormattedCharSequence>(this.cachedToolTip);
        Collection<Component> toAppend = null;
        if (this.volume.isMouseOver(mouseX, mouseY)) {
            toAppend = VOLUME_HELP;
        } else if (this.blockButton.isMouseOver(mouseX, mouseY)) {
            toAppend = BLOCK_HELP;
        } else if (this.cullButton.isMouseOver(mouseX, mouseY)) {
            toAppend = CULL_HELP;
        } else if (this.playButton != null && this.playButton.isMouseOver(mouseX, mouseY)) {
            toAppend = PLAY_HELP;
        }
        if (toAppend != null) {
            generatedTip.add(FormattedCharSequence.EMPTY);
            toAppend.forEach(e -> generatedTip.add(e.getVisualOrderText()));
        }
        return generatedTip;
    }

    private Optional<String> resolveDisplayName(String namespace) {
        Optional<String> displayName = ModInformation.getModDisplayName(namespace);
        if (displayName.isPresent()) {
            return displayName;
        }
        return GameUtils.getResourceManager().listPacks().filter(pack -> pack.getNamespaces(PackType.CLIENT_RESOURCES).contains(namespace)).map(PackResources::packId).findAny();
    }

    public IndividualSoundConfigEntry getData() {
        return this.config;
    }
}

