/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlList;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlListEntry;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.gui.ColorPalette;

public class IndividualSoundControlScreen
extends Screen {
    private static final int TOP_OFFSET = 10;
    private static final int BOTTOM_OFFSET = 15;
    private static final int HEADER_HEIGHT = 40;
    private static final int FOOTER_HEIGHT = 80;
    private static final int SEARCH_BAR_WIDTH = 200;
    private static final int SEARCH_BAR_HEIGHT = 20;
    private static final int SELECTION_HEIGHT_OFFSET = 5;
    private static final int SELECTION_WIDTH = 600;
    private static final int SELECTION_HEIGHT = 24;
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 10;
    private static final int CONTROL_WIDTH = 130;
    private static final int TOOLTIP_Y_OFFSET = 30;
    private static final Component SAVE = Component.translatable((String)"gui.done");
    private static final Component CANCEL = Component.translatable((String)"gui.cancel");
    protected final Screen parent;
    protected final boolean enablePlay;
    protected final Consumer<IndividualSoundControlScreen> onClose;
    protected EditBox searchField;
    protected IndividualSoundControlList soundConfigList;
    protected Button save;
    protected Button cancel;

    public IndividualSoundControlScreen(Screen parent, boolean enablePlay) {
        this(parent, enablePlay, ignore -> {});
    }

    public IndividualSoundControlScreen(Screen parent, boolean enablePlay, Consumer<IndividualSoundControlScreen> onClose) {
        super((Component)Component.translatable((String)"dsurround.text.keybind.individualSoundConfig"));
        this.parent = parent;
        this.enablePlay = enablePlay;
        this.onClose = onClose;
    }

    protected void init() {
        int searchBarLeftMargin = (this.width - 200) / 2;
        int searchBarY = 30;
        this.searchField = new EditBox(this.font, searchBarLeftMargin, 30, 200, 20, this.searchField, (Component)Component.empty());
        this.searchField.setResponder(filter -> this.soundConfigList.setSearchFilter(() -> filter));
        this.addWidget((GuiEventListener)this.searchField);
        int topY = 55;
        int bottomY = this.height - 15 - 80 - 5;
        this.soundConfigList = new IndividualSoundControlList(this, GameUtils.getMC(), this.width, bottomY, 55, 600, 24, this.enablePlay, () -> this.searchField.getValue(), this.soundConfigList);
        this.addWidget((GuiEventListener)this.soundConfigList);
        int controlMargin = (this.width - 130) / 2;
        int controlHeight = this.height - 15 - 20;
        this.save = Button.builder((Component)SAVE, this::save).size(60, 20).pos(controlMargin, controlHeight).build();
        this.addWidget((GuiEventListener)this.save);
        this.cancel = Button.builder((Component)CANCEL, this::cancel).size(60, 20).pos(controlMargin + 60 + 10, controlHeight).build();
        this.addWidget((GuiEventListener)this.cancel);
        this.setFocused((GuiEventListener)this.searchField);
    }

    public void tick() {
        this.soundConfigList.tick();
        if (this.enablePlay) {
            GameUtils.getSoundManager().tick(false);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers) || this.searchField.keyPressed(keyCode, scanCode, modifiers);
    }

    public void closeScreen() {
        GameUtils.setScreen(this.parent);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.searchField.charTyped(codePoint, modifiers);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        IndividualSoundControlListEntry entry;
        int renderWidth = Mth.clamp((int)(context.guiWidth() - 20), (int)200, (int)600);
        this.soundConfigList.setRowWidth(renderWidth);
        if (this.parent == null) {
            this.renderTransparentBackground(context);
        } else {
            this.renderMenuBackground(context);
        }
        context.drawCenteredString(this.font, this.title, this.width / 2, 10, ColorPalette.MC_WHITE.getValue());
        this.soundConfigList.render(context, mouseX, mouseY, partialTicks);
        this.searchField.render(context, mouseX, mouseY, partialTicks);
        this.save.render(context, mouseX, mouseY, partialTicks);
        this.cancel.render(context, mouseX, mouseY, partialTicks);
        if (this.soundConfigList.isMouseOver(mouseX, mouseY) && (entry = this.soundConfigList.getEntryAt(mouseX, mouseY)) != null) {
            List<FormattedCharSequence> toolTip = entry.getToolTip(mouseX, mouseY);
            context.renderTooltip(this.font, toolTip, mouseX, mouseY + 30);
        }
    }

    protected void save(Button button) {
        this.soundConfigList.saveChanges();
        this.onClose();
        this.closeScreen();
    }

    protected void cancel(Button button) {
        this.onClose();
        this.closeScreen();
    }

    public void onClose() {
        this.onClose.accept(this);
        super.onClose();
    }
}

