/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.gui.WarmToast;
import org.orecruncher.dsurround.sound.SoundMetadata;

public class SoundToast {
    private static final WarmToast.Profile SOUND_TOAST_PROFILE = new WarmToast.Profile(ResourceLocation.withDefaultNamespace((String)"toast/advancement"), 5000, ColorPalette.PUMPKIN_ORANGE, ColorPalette.WHEAT);

    public static void create(Music music) {
        ISoundLibrary soundLibrary = ContainerManager.resolve(ISoundLibrary.class);
        SoundMetadata metadata = soundLibrary.getSoundMetadata(((SoundEvent)music.getEvent().value()).getLocation());
        if (metadata != null && !metadata.getCredits().isEmpty()) {
            Component title = metadata.getTitle();
            if (!Component.empty().equals((Object)title)) {
                Component author = metadata.getCredits().get(0).author();
                MutableComponent titleLine = Component.translatable((String)"dsurround.text.toast.music.title", (Object[])new Object[]{title});
                MutableComponent authorLine = Component.translatable((String)"dsurround.text.toast.music.author", (Object[])new Object[]{author});
                WarmToast toast = WarmToast.multiline(GameUtils.getMC(), SOUND_TOAST_PROFILE, (Component)titleLine, (Component)authorLine);
                GameUtils.getMC().getToasts().addToast((Toast)toast);
            }
        }
    }
}

