/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import com.google.common.collect.ImmutableList;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlListEntry;
import org.orecruncher.dsurround.lib.gui.SliderControl;

public class VolumeSliderControl
extends SliderControl {
    private static final int SLIDER_WIDTH = 100;
    private static final int SLIDER_HEIGHT = 20;
    private static final DecimalFormat FORMAT;
    private static final Component OFF;
    private final IndividualSoundControlListEntry entry;

    public VolumeSliderControl(IndividualSoundControlListEntry entry, int x, int y) {
        this(entry, x, y, (List<FormattedCharSequence>)ImmutableList.of());
    }

    public VolumeSliderControl(IndividualSoundControlListEntry entry, int x, int y, List<FormattedCharSequence> toolTip) {
        super(x, y, 100, 20, 0.0, 400.0, 1.0f, entry.getData().volumeScale, toolTip);
        this.entry = entry;
        this.updateMessage();
    }

    @Override
    protected void updateMessage() {
        Component text = this.getValue() == 0.0 ? OFF : Component.literal((String)(FORMAT.format(this.getValue()) + "%"));
        this.setMessage(text);
    }

    @Override
    protected void applyValue() {
        this.entry.getData().volumeScale = (int)this.getValue();
    }

    static {
        OFF = Component.translatable((String)"options.off");
        FORMAT = new DecimalFormat("0");
        FORMAT.setRoundingMode(RoundingMode.HALF_UP);
        FORMAT.setDecimalSeparatorAlwaysShown(false);
    }
}

