/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.lib.Localization;

public enum DayCycle {
    NO_SKY("NoSky"),
    SUNRISE("Sunrise"),
    SUNSET("Sunset"),
    DAYTIME("Daytime"),
    NIGHTTIME("Nighttime");

    private static final float DAYTIME_THRESHOLD = 274.0f;
    private static final float SUNRISE_THRESHOLD = 259.0f;
    private static final float NIGHTTIME_THRESHOLD = 94.0f;
    private static final float SUNSET_THRESHOLD = 79.0f;
    private final String localizeString;

    private DayCycle(String localName) {
        this.localizeString = "dsurround.format." + localName;
    }

    public static boolean isDaytime(Level world) {
        return DayCycle.getCycle(world) == DAYTIME;
    }

    public static boolean isNighttime(Level world) {
        return DayCycle.getCycle(world) == NIGHTTIME;
    }

    public static boolean isSunrise(Level world) {
        return DayCycle.getCycle(world) == SUNRISE;
    }

    public static boolean isSunset(Level world) {
        return DayCycle.getCycle(world) == SUNSET;
    }

    public static DayCycle getCycle(Level world) {
        if (world.dimensionType().hasCeiling() || !world.dimensionType().hasSkyLight()) {
            return NO_SKY;
        }
        float angleDegrees = world.getTimeOfDay(0.0f) * 360.0f;
        if (angleDegrees > 274.0f) {
            return DAYTIME;
        }
        if (angleDegrees > 259.0f) {
            return SUNRISE;
        }
        if (angleDegrees > 94.0f) {
            return NIGHTTIME;
        }
        if (angleDegrees > 79.0f) {
            return SUNSET;
        }
        return DAYTIME;
    }

    public static float getMoonSize(Level world) {
        return world.getMoonBrightness();
    }

    public String getFormattedName() {
        return Localization.load(this.localizeString);
    }
}

