/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.lib.MinecraftServerType;

public final class GameUtils {
    private GameUtils() {
    }

    public static Optional<Player> getPlayer() {
        return Optional.ofNullable(GameUtils.getMC().player);
    }

    public static Optional<ClientLevel> getWorld() {
        return Optional.ofNullable(GameUtils.getMC().level);
    }

    public static Optional<RegistryAccess> getRegistryManager() {
        return GameUtils.getWorld().map(Level::registryAccess);
    }

    public static Optional<Screen> getCurrentScreen() {
        return Optional.ofNullable(GameUtils.getMC().screen);
    }

    public static void setScreen(Screen screen) {
        GameUtils.getMC().setScreen(screen);
    }

    public static ParticleEngine getParticleManager() {
        return GameUtils.getMC().particleEngine;
    }

    public static Options getGameSettings() {
        return GameUtils.getMC().options;
    }

    public static Font getTextRenderer() {
        return GameUtils.getMC().font;
    }

    public static StringSplitter getTextHandler() {
        return GameUtils.getTextRenderer().getSplitter();
    }

    public static SoundManager getSoundManager() {
        return GameUtils.getMC().getSoundManager();
    }

    public static ResourceManager getResourceManager() {
        return GameUtils.getMC().getResourceManager();
    }

    public static TextureManager getTextureManager() {
        return GameUtils.getMC().getTextureManager();
    }

    public static boolean isInGame() {
        return GameUtils.getWorld().isPresent() && GameUtils.getPlayer().isPresent();
    }

    public static boolean isPaused() {
        return GameUtils.getMC().isPaused();
    }

    public static boolean isSinglePlayer() {
        return GameUtils.getMC().isSingleplayer();
    }

    public static boolean isFirstPersonView() {
        return GameUtils.getGameSettings().getCameraType() == CameraType.FIRST_PERSON;
    }

    public static Minecraft getMC() {
        return Objects.requireNonNull(Minecraft.getInstance());
    }

    public static Optional<String> getServerBrand() {
        ClientPacketListener connection = GameUtils.getMC().getConnection();
        if (connection != null) {
            return Optional.ofNullable(connection.serverBrand());
        }
        return Optional.empty();
    }

    public static MinecraftServerType getServerType() {
        return GameUtils.getServerBrand().map(MinecraftServerType::fromBrand).orElse(MinecraftServerType.VANILLA);
    }
}

