/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class IdentityUtils {
    public static final Codec<ResourceLocation> CODEC = Codec.STRING.xmap(s -> IdentityUtils.resolveIdentifier("dsurround", s), ResourceLocation::toString).stable();

    public static ResourceLocation resolveIdentifier(String defaultDomain, String identifierString) {
        Preconditions.checkNotNull((Object)defaultDomain);
        Preconditions.checkNotNull((Object)identifierString);
        if (identifierString.charAt(0) == '#') {
            identifierString = identifierString.substring(1);
        }
        ResourceLocation res = identifierString.charAt(0) == '@' ? ResourceLocation.tryBuild((String)"minecraft", (String)identifierString.substring(1)) : (!identifierString.contains(":") ? ResourceLocation.tryBuild((String)defaultDomain, (String)identifierString) : ResourceLocation.parse((String)identifierString));
        return res;
    }

    public static ResourceLocation resolveIdentifier(String identifierString) {
        Preconditions.checkNotNull((Object)identifierString);
        if (identifierString.charAt(0) == '#') {
            identifierString = identifierString.substring(1);
        }
        ResourceLocation res = identifierString.charAt(0) == '@' ? ResourceLocation.tryBuild((String)"minecraft", (String)identifierString.substring(1)) : ResourceLocation.parse((String)identifierString);
        return res;
    }

    public static Optional<ResourceLocation> tryParse(String identifierString) {
        return Optional.ofNullable(ResourceLocation.tryParse((String)identifierString));
    }
}

