/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.platform.IMinecraftDirectories;
import org.orecruncher.dsurround.lib.platform.ModInformation;
import org.orecruncher.dsurround.lib.system.ISystemClock;
import org.orecruncher.dsurround.lib.system.ITickCount;
import org.orecruncher.dsurround.lib.system.SystemClock;
import org.orecruncher.dsurround.lib.system.TickCounter;
import org.orecruncher.dsurround.lib.threading.ClientTasking;
import org.orecruncher.dsurround.lib.threading.IClientTasking;

public final class Library {
    public static final String MOD_ID = "dsurround";
    public static final IModLog LOGGER = ModLog.create("dsurround");

    public static void initialize() {
        LOGGER.info("Library initializing", new Object[0]);
        Library.configureServiceDependencies();
        ClientState.STARTED.register(ignore -> LOGGER.info("Client starting", new Object[0]), HandlerPriority.VERY_HIGH);
        ClientState.STOPPING.register(ignore -> LOGGER.info("Client stopping", new Object[0]), HandlerPriority.VERY_HIGH);
    }

    private static void configureServiceDependencies() {
        ModInformation modInfo = ModInformation.getModInformation(MOD_ID).orElseThrow(() -> {
            LOGGER.warn("Unable to acquire mod information for %s!", MOD_ID);
            return new RuntimeException("Unable to acquire mod information!");
        });
        ContainerManager.getRootContainer().registerSingleton(ModInformation.class, modInfo).registerSingleton(ISystemClock.class, SystemClock.class).registerSingleton(IMinecraftDirectories.class, modInfo).registerSingleton(IClientTasking.class, ClientTasking.class).registerSingleton(ITickCount.class, TickCounter.class);
    }
}

