/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

public enum MinecraftServerType {
    VANILLA(false),
    PAPER(false),
    FABRIC(true),
    FORGE(true),
    NEOFORGE(true),
    OTHER(false);

    private final boolean isModded;

    private MinecraftServerType(boolean isModded) {
        this.isModded = isModded;
    }

    public boolean isModded() {
        return this.isModded;
    }

    public static MinecraftServerType fromBrand(String serverBrand) {
        String brand;
        return switch (brand = serverBrand.toLowerCase()) {
            case "vanilla" -> VANILLA;
            case "paper" -> PAPER;
            case "forge" -> FORGE;
            case "fabric" -> FABRIC;
            case "neoforge" -> NEOFORGE;
            default -> OTHER;
        };
    }
}

