/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.invoke.LambdaMetafactory;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.IdentityUtils;
import org.orecruncher.dsurround.lib.block.BlockStateParseException;
import org.orecruncher.dsurround.lib.block.BlockStateParser;
import org.orecruncher.dsurround.lib.block.BlockStateProperties;
import org.orecruncher.dsurround.lib.block.MatchOnBlock;
import org.orecruncher.dsurround.lib.block.MatchOnBlockState;
import org.orecruncher.dsurround.lib.block.MatchOnBlockTag;

public abstract class BlockStateMatcher
implements IMatcher<BlockState> {
    public static final Codec<IMatcher<BlockState>> CODEC = Codec.STRING.comapFlatMap(BlockStateMatcher::manifest, (Function<IMatcher, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/orecruncher/dsurround/lib/IMatcher;)Ljava/lang/String;)()).stable();
    public static final String TAG_TYPE = "#";

    private static DataResult<IMatcher<BlockState>> manifest(String blockId) {
        try {
            return DataResult.success(BlockStateMatcher.create(blockId, true, true));
        }
        catch (Throwable t) {
            return DataResult.error(t::getMessage);
        }
    }

    public static IMatcher<BlockState> asGeneric(BlockState state) {
        return BlockStateMatcher.create(state.getBlock());
    }

    public static IMatcher<BlockState> create(BlockState state) {
        return new MatchOnBlockState(state);
    }

    public static IMatcher<BlockState> create(Block block) {
        return new MatchOnBlock(block);
    }

    public static IMatcher<BlockState> create(String blockId) throws BlockStateParseException {
        return BlockStateMatcher.create(blockId, true, true);
    }

    public static IMatcher<BlockState> create(String blockId, boolean allowTags, boolean allowMaterials) throws BlockStateParseException {
        if (blockId.startsWith(TAG_TYPE)) {
            if (allowTags) {
                return BlockStateMatcher.createTagMatcher(blockId);
            }
            throw new BlockStateParseException(String.format("Block id %s is for a tag, and it is not permitted in this context", blockId));
        }
        return BlockStateMatcher.createBlockStateMatcher(BlockStateParser.parse(blockId));
    }

    private static BlockStateMatcher createTagMatcher(String tagId) throws BlockStateParseException {
        try {
            ResourceLocation id = IdentityUtils.resolveIdentifier("dsurround", tagId);
            return new MatchOnBlockTag(id);
        }
        catch (Throwable ignored) {
            throw new BlockStateParseException(String.format("%s is not a valid block tag", tagId));
        }
    }

    private static BlockStateMatcher createBlockStateMatcher(BlockStateParser.ParseResult result) throws BlockStateParseException {
        Block block = result.getBlock();
        BlockState defaultState = block.defaultBlockState();
        StateDefinition container = block.getStateDefinition();
        if (container.getPossibleStates().size() == 1) {
            return new MatchOnBlock(defaultState.getBlock());
        }
        if (!result.hasProperties()) {
            return new MatchOnBlock(block);
        }
        Map<String, String> properties = result.getProperties();
        IdentityHashMap props = new IdentityHashMap(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String s = entry.getKey();
            Property prop = container.getProperty(s);
            if (prop != null) {
                Optional optional = prop.getValue(entry.getValue());
                if (optional.isPresent()) {
                    props.put(prop, (Comparable)optional.get());
                    continue;
                }
                String msg = String.format("Value '%s' for property '%s' not found for block '%s'", entry.getValue(), s, result.getBlockName());
                throw new BlockStateParseException(msg);
            }
            String msg = String.format("Property %s not found for block %s", s, result.getBlockName());
            throw new BlockStateParseException(msg);
        }
        return new MatchOnBlockState(defaultState, new BlockStateProperties(props));
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract boolean match(BlockState var1);
}

