/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.block;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.PatternValidation;
import org.orecruncher.dsurround.lib.block.BlockStateParseException;

final class BlockStateParser {
    private BlockStateParser() {
    }

    public static ParseResult parse(String blockName) throws BlockStateParseException {
        String temp = blockName;
        int idx = temp.indexOf(43);
        String extras = null;
        if (idx > 0) {
            extras = temp.substring(idx + 1);
            temp = temp.substring(0, idx);
        }
        Object properties = ImmutableMap.of();
        idx = temp.indexOf(91);
        if (idx > 0) {
            try {
                int end = temp.indexOf(93);
                if (end < 1) {
                    throw new BlockStateParseException("Missing ']'");
                }
                String propString = temp.substring(idx + 1, end);
                properties = Arrays.stream(propString.split(",")).map(elem -> elem.split("=")).collect(Collectors.toMap(e -> e[0], e -> e[1]));
                for (String propName : properties.keySet()) {
                    if (PatternValidation.BLOCKSTATE_PROPERTY_NAME.matcher(propName).matches()) continue;
                    throw new BlockStateParseException(String.format("Property name %s for block %s is invalid", propName, blockName));
                }
                temp = temp.substring(0, idx);
            }
            catch (Throwable ignore) {
                throw new BlockStateParseException(String.format("Unable to parse properties of '%s'", blockName));
            }
        }
        ResourceLocation resource = ResourceLocation.tryParse((String)temp);
        if (temp == null) {
            throw new BlockStateParseException(String.format("Invalid block name '%s' for entry '%s'", temp, blockName));
        }
        Block block = (Block)BuiltInRegistries.BLOCK.get(resource);
        if (block == Blocks.AIR && !"minecraft:air".equals(temp)) {
            throw new BlockStateParseException(String.format("Unknown block '%s' for entry '%s'", temp, blockName));
        }
        return new ParseResult(temp, block, (Map<String, String>)properties, extras);
    }

    public static final class ParseResult {
        private final String blockName;
        private final Block block;
        private final Map<String, String> properties;
        private final String extras;

        private ParseResult(String blockName, Block block, Map<String, String> props, @Nullable String extras) {
            this.blockName = blockName;
            this.block = block;
            this.properties = props;
            this.extras = extras;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public Block getBlock() {
            return this.block;
        }

        public boolean hasProperties() {
            return !this.properties.isEmpty();
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public boolean hasExtras() {
            return !StringUtils.isEmpty((CharSequence)this.extras);
        }

        @Nullable
        public String getExtras() {
            return this.extras;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getBlockName());
            if (this.hasProperties()) {
                builder.append('[');
                String props = this.getProperties().entrySet().stream().map(Objects::toString).collect(Collectors.joining(","));
                builder.append(props);
                builder.append(']');
            }
            if (!StringUtils.isEmpty((CharSequence)this.extras)) {
                builder.append('+').append(this.extras);
            }
            return builder.toString();
        }
    }
}

