/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.block.MatchOnBlockState;
import org.orecruncher.dsurround.lib.logging.IModLog;

public class BlockStateProperties {
    private static final IModLog LOGGER = Library.LOGGER;
    public static final BlockStateProperties NONE = new BlockStateProperties();
    private final Map<Property<?>, Comparable<?>> props;

    private BlockStateProperties() {
        this.props = ImmutableMap.of();
    }

    public BlockStateProperties(BlockState state) {
        this(state.getValues());
    }

    public BlockStateProperties(Map<Property<?>, Comparable<?>> props) {
        this.props = props;
    }

    public boolean matches(BlockState state) {
        try {
            for (Map.Entry<Property<?>, Comparable<?>> kvp : this.props.entrySet()) {
                Comparable comp = state.getValue(kvp.getKey());
                if (comp.equals(kvp.getValue())) continue;
                return false;
            }
            return true;
        }
        catch (Throwable ignored) {
            LOGGER.warn("Property list %s does not correspond the properties in %s", this.toString(), new MatchOnBlockState(state).toString());
            return false;
        }
    }

    public boolean matches(BlockStateProperties props) {
        return this.matches(props.props);
    }

    public boolean matches(Map<Property<?>, Comparable<?>> m) {
        try {
            if (this.props == m) {
                return true;
            }
            if (this.props.size() > m.size()) {
                return false;
            }
            for (Map.Entry<Property<?>, Comparable<?>> kvp : this.props.entrySet()) {
                Comparable<?> comp = m.get(kvp.getKey());
                if (comp.equals(kvp.getValue())) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int hashCode() {
        int code = 0;
        for (Map.Entry<Property<?>, Comparable<?>> kvp : this.props.entrySet()) {
            code = code * 31 + kvp.getKey().hashCode();
            code = code * 31 + kvp.getValue().hashCode();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockStateProperties)) {
            return false;
        }
        BlockStateProperties e = (BlockStateProperties)obj;
        return this.props.size() == e.props.size() && this.matches(e.props);
    }

    public String getFormattedProperties() {
        if (this.props.isEmpty()) {
            return "";
        }
        String txt = this.props.entrySet().stream().map(kvp -> ((Property)kvp.getKey()).getName() + "=" + ((Comparable)kvp.getValue()).toString()).collect(Collectors.joining(","));
        return "[" + txt + "]";
    }

    public String toString() {
        return "BlockStateProperties{" + this.getFormattedProperties() + "}";
    }
}

