/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config;

import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.orecruncher.dsurround.lib.config.ConfigElement;
import org.orecruncher.dsurround.lib.config.ConfigOptions;
import org.orecruncher.dsurround.lib.config.ConfigurationData;
import org.orecruncher.dsurround.lib.gui.ColorPalette;

public abstract class AbstractConfigScreenFactory
implements Function<Screen, Screen> {
    private static final Style STYLE_RESTART = Style.EMPTY.withColor(ColorPalette.RED);
    private static final Component CLIENT_RESTART_REQUIRED = Component.translatable((String)"dsurround.config.tooltip.clientRestartRequired").withStyle(STYLE_RESTART);
    private static final Component WORLD_RESTART_REQUIRED = Component.translatable((String)"dsurround.config.tooltip.worldRestartRequired").withStyle(STYLE_RESTART);
    private static final Component ASSET_RELOAD_REQUIRED = Component.translatable((String)"dsurround.config.tooltip.assetReloadRequired").withStyle(STYLE_RESTART);
    private static final Component EMPTY_LINE = Component.literal((String)" ");
    protected final ConfigOptions options;
    protected final ConfigurationData configData;

    public AbstractConfigScreenFactory(ConfigOptions options, ConfigurationData config) {
        this.options = options;
        this.configData = config;
    }

    protected Collection<Component> generateToolTipCollection(ConfigElement.PropertyValue<?> pv) {
        ConfigElement.IRangeTooltip rt;
        Collection<Component> toolTipEntries = this.options.transformTooltip(pv.getTooltip(this.options.getTooltipStyle()));
        toolTipEntries.add(EMPTY_LINE);
        toolTipEntries.add(pv.getDefaultValueTooltip());
        if (pv instanceof ConfigElement.IRangeTooltip && (rt = (ConfigElement.IRangeTooltip)((Object)pv)).hasRange()) {
            toolTipEntries.add(rt.getRangeTooltip());
        }
        if (pv.isClientRestartRequired()) {
            toolTipEntries.add(EMPTY_LINE);
            toolTipEntries.add(CLIENT_RESTART_REQUIRED);
        } else if (pv.isWorldRestartRequired()) {
            toolTipEntries.add(EMPTY_LINE);
            toolTipEntries.add(WORLD_RESTART_REQUIRED);
        } else if (pv.isAssetReloadRequired()) {
            toolTipEntries.add(EMPTY_LINE);
            toolTipEntries.add(ASSET_RELOAD_REQUIRED);
        }
        return toolTipEntries;
    }

    @Override
    public abstract Screen apply(Screen var1);
}

